/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mintjams.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import jp.morpho.util.BadPaddingException;
import jp.morpho.util.Coder;

public class Base64Coder
extends Coder {
    Logger log;
    private static final byte[] encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decoding = new byte[128];
    private int _opmode;
    private Coder coder;
    static /* synthetic */ Class class$0;

    static {
        int i = 65;
        while (i <= 90) {
            Base64Coder.decoding[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            Base64Coder.decoding[i] = (byte)(i - 97 + 26);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            Base64Coder.decoding[i] = (byte)(i - 48 + 52);
            ++i;
        }
        Base64Coder.decoding[43] = 62;
        Base64Coder.decoding[47] = 63;
    }

    public Base64Coder() {
        super("Base64");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.co.mintjams.util.Base64Coder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this._opmode = 0;
        this.coder = null;
    }

    public void init(int opmode) {
        if (opmode == 1) {
            this.coder = new Base64Encoder();
        } else if (opmode == 2) {
            this.coder = new Base64Decoder();
        }
        this.coder.init(opmode);
        this._opmode = opmode;
    }

    public byte[] update(int input) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input);
    }

    public byte[] update(byte[] input) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input);
    }

    public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input, inputOffset, inputLen);
    }

    public byte[] doFinal() throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal();
    }

    public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input);
    }

    public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input);
    }

    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input, inputOffset, inputLen);
    }

    class Base64Encoder
    extends Coder {
        private byte[] inputBuffer;
        private int inputedLength;

        public Base64Encoder() {
            super("Base64");
            this.inputBuffer = null;
            this.inputedLength = 0;
        }

        public void init(int opmode) {
            this.inputBuffer = new byte[3];
            this.inputedLength = 0;
        }

        public byte[] update(int input) throws IllegalStateException {
            this.inputBuffer[this.inputedLength++] = (byte)(0xFF & input);
            if (this.inputedLength == 3) {
                return this.transform();
            }
            return null;
        }

        public byte[] update(byte[] input) throws IllegalStateException {
            return this.update(input, 0, input.length);
        }

        public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = inputOffset;
            int inputCount = 0;
            while (inputCount < inputLen) {
                byte[] encoded = this.update(input[i]);
                if (encoded != null) {
                    try {
                        out.write(encoded);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                }
                ++i;
                ++inputCount;
            }
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        public byte[] doFinal() throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[0], 0, 0);
        }

        public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[input], 0, 1);
        }

        public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(input, 0, input.length);
        }

        public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
            byte[] encoded;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (inputLen > 0 && (encoded = this.update(input, inputOffset, inputLen)) != null) {
                try {
                    out.write(encoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            if (this.inputedLength > 0 && (encoded = this.transform()) != null) {
                try {
                    out.write(encoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            this.init(Base64Coder.this._opmode);
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        private byte[] transform() {
            if (this.inputedLength == 0) {
                return null;
            }
            byte[] output = new byte[4];
            if (this.inputedLength < 3) {
                this.inputBuffer[2] = 0;
                if (this.inputedLength < 2) {
                    this.inputBuffer[1] = 0;
                }
            }
            output[0] = encoding[this.inputBuffer[0] >>> 2 & 0x3F];
            output[1] = encoding[this.inputBuffer[0] << 4 & 0x30 | this.inputBuffer[1] >>> 4 & 0xF];
            output[2] = encoding[this.inputBuffer[1] << 2 & 0x3C | this.inputBuffer[2] >>> 6 & 3];
            output[3] = encoding[this.inputBuffer[2] & 0x3F];
            if (this.inputedLength < 3) {
                output[3] = 61;
                if (this.inputedLength < 2) {
                    output[2] = 61;
                }
            }
            this.inputedLength = 0;
            return output;
        }
    }

    class Base64Decoder
    extends Coder {
        private byte[] inputBuffer;
        private int inputedLength;

        public Base64Decoder() {
            super("Base64");
            this.inputBuffer = null;
            this.inputedLength = 0;
        }

        public void init(int opmode) {
            this.inputBuffer = new byte[4];
            this.inputedLength = 0;
        }

        public byte[] update(int input) throws IllegalStateException {
            this.inputBuffer[this.inputedLength++] = (byte)(0xFF & input);
            if (this.inputedLength == 4) {
                try {
                    return this.transform();
                }
                catch (BadPaddingException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            return null;
        }

        public byte[] update(byte[] input) throws IllegalStateException {
            return this.update(input, 0, input.length);
        }

        public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = inputOffset;
            int inputCount = 0;
            while (inputCount < inputLen) {
                byte[] decoded = this.update(input[i]);
                if (decoded != null) {
                    try {
                        out.write(decoded);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                }
                ++i;
                ++inputCount;
            }
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        public byte[] doFinal() throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[0], 0, 0);
        }

        public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[input], 0, 1);
        }

        public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(input, 0, input.length);
        }

        public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
            byte[] decoded;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (inputLen > 0 && (decoded = this.update(input, inputOffset, inputLen)) != null) {
                try {
                    out.write(decoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            if (this.inputedLength > 0 && (decoded = this.transform()) != null) {
                try {
                    out.write(decoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            this.init(Base64Coder.this._opmode);
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        private byte[] transform() throws BadPaddingException {
            if (this.inputedLength == 0) {
                return null;
            }
            if (this.inputedLength < 4) {
                throw new BadPaddingException("Unexpected end-of-file");
            }
            byte[] output = null;
            if (this.inputBuffer[2] == 61) {
                byte b1 = decoding[this.inputBuffer[0]];
                byte b2 = decoding[this.inputBuffer[1]];
                output = new byte[]{(byte)(b1 << 2 | b2 >> 4)};
            } else if (this.inputBuffer[3] == 61) {
                byte b1 = decoding[this.inputBuffer[0]];
                byte b2 = decoding[this.inputBuffer[1]];
                byte b3 = decoding[this.inputBuffer[2]];
                output = new byte[]{(byte)(b1 << 2 | b2 >> 4), (byte)(b2 << 4 | b3 >> 2)};
            } else {
                byte b1 = decoding[this.inputBuffer[0]];
                byte b2 = decoding[this.inputBuffer[1]];
                byte b3 = decoding[this.inputBuffer[2]];
                byte b4 = decoding[this.inputBuffer[3]];
                output = new byte[]{(byte)(b1 << 2 | b2 >> 4), (byte)(b2 << 4 | b3 >> 2), (byte)(b3 << 6 | b4)};
            }
            this.inputedLength = 0;
            return output;
        }
    }
}

