/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mintjams.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.morpho.util.BadPaddingException;
import jp.morpho.util.Coder;

public class HexCoder
extends Coder {
    Logger log;
    private static final byte[] encoding = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private int _opmode;
    private Coder coder;
    static /* synthetic */ Class class$0;

    public HexCoder() {
        super("Hex");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.co.mintjams.util.HexCoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this._opmode = 0;
        this.coder = null;
    }

    public void init(int opmode) {
        if (opmode == 1) {
            this.coder = new HexEncoder();
        } else if (opmode == 2) {
            this.coder = new HexDecoder();
        }
        this.coder.init(opmode);
        this._opmode = opmode;
    }

    public byte[] update(int input) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input);
    }

    public byte[] update(byte[] input) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input);
    }

    public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.update(input, inputOffset, inputLen);
    }

    public byte[] doFinal() throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal();
    }

    public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input);
    }

    public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input);
    }

    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
        if (this.coder == null) {
            throw new IllegalStateException("Coder not initialized.");
        }
        return this.coder.doFinal(input, inputOffset, inputLen);
    }

    class HexEncoder
    extends Coder {
        private byte[] inputBuffer;
        private int inputedLength;

        public HexEncoder() {
            super("Hex");
            this.inputBuffer = null;
            this.inputedLength = 0;
        }

        public void init(int opmode) {
            this.inputBuffer = new byte[1];
            this.inputedLength = 0;
        }

        public byte[] update(int input) throws IllegalStateException {
            this.inputBuffer[this.inputedLength++] = (byte)(0xFF & input);
            if (this.inputedLength == 1) {
                return this.transform();
            }
            return null;
        }

        public byte[] update(byte[] input) throws IllegalStateException {
            return this.update(input, 0, input.length);
        }

        public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = inputOffset;
            int inputCount = 0;
            while (inputCount < inputLen) {
                byte[] encoded = this.update(input[i]);
                if (encoded != null) {
                    try {
                        out.write(encoded);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                }
                ++i;
                ++inputCount;
            }
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        public byte[] doFinal() throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[0], 0, 0);
        }

        public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[input], 0, 1);
        }

        public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(input, 0, input.length);
        }

        public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
            byte[] encoded;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (inputLen > 0 && (encoded = this.update(input, inputOffset, inputLen)) != null) {
                try {
                    out.write(encoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            if (this.inputedLength > 0 && (encoded = this.transform()) != null) {
                try {
                    out.write(encoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            this.init(HexCoder.this._opmode);
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        private byte[] transform() {
            if (this.inputedLength == 0) {
                return null;
            }
            byte[] output = new byte[]{encoding[this.inputBuffer[0] >> 4 & 0xF], encoding[this.inputBuffer[0] & 0xF]};
            this.inputedLength = 0;
            return output;
        }
    }

    class HexDecoder
    extends Coder {
        private byte[] inputBuffer;
        private int inputedLength;

        public HexDecoder() {
            super("Hex");
            this.inputBuffer = null;
            this.inputedLength = 0;
        }

        public void init(int opmode) {
            this.inputBuffer = new byte[2];
            this.inputedLength = 0;
        }

        public byte[] update(int input) throws IllegalStateException {
            this.inputBuffer[this.inputedLength++] = (byte)(0xFF & input);
            if (this.inputedLength == 2) {
                try {
                    return this.transform();
                }
                catch (BadPaddingException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            return null;
        }

        public byte[] update(byte[] input) throws IllegalStateException {
            return this.update(input, 0, input.length);
        }

        public byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = inputOffset;
            int inputCount = 0;
            while (inputCount < inputLen) {
                byte[] decoded = this.update(input[i]);
                if (decoded != null) {
                    try {
                        out.write(decoded);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                }
                ++i;
                ++inputCount;
            }
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        public byte[] doFinal() throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[0], 0, 0);
        }

        public byte[] doFinal(int input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(new byte[input], 0, 1);
        }

        public byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException {
            return this.doFinal(input, 0, input.length);
        }

        public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException {
            byte[] decoded;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (inputLen > 0 && (decoded = this.update(input, inputOffset, inputLen)) != null) {
                try {
                    out.write(decoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            if (this.inputedLength > 0 && (decoded = this.transform()) != null) {
                try {
                    out.write(decoded);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            this.init(HexCoder.this._opmode);
            if (out.size() == 0) {
                return null;
            }
            return out.toByteArray();
        }

        private byte[] transform() throws BadPaddingException {
            if (this.inputedLength == 0) {
                return null;
            }
            if (this.inputedLength < 2) {
                throw new BadPaddingException("Unexpected end-of-file");
            }
            byte[] output = null;
            try {
                byte left = (byte)new String(new byte[]{this.inputBuffer[0]}, "ISO-8859-1").toLowerCase().charAt(0);
                byte right = (byte)new String(new byte[]{this.inputBuffer[1]}, "ISO-8859-1").toLowerCase().charAt(0);
                output = new byte[]{left < 97 ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4)};
                output[0] = right < 97 ? (byte)(output[0] + (byte)(right - 48)) : (byte)(output[0] + (byte)(right - 97 + 10));
            }
            catch (Exception e) {
                HexCoder.this.log.log(Level.SEVERE, "Unsupported encoding: ISO-8859-1", e);
                throw new IllegalStateException(e.getMessage());
            }
            this.inputedLength = 0;
            return output;
        }
    }
}

