/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.morpho.config.ConfigureException;
import jp.morpho.config.Node;
import org.xml.sax.Attributes;

public class CallNode
extends Node {
    public CallNode(Node parent, Attributes attributes) {
        super(parent, attributes);
    }

    public int getTag() {
        return 3;
    }

    public Object configure(Object obj) throws ConfigureException {
        try {
            Object newObj;
            Class<?> objCls = this.getNodeClass();
            if (objCls != null) {
                obj = null;
            } else {
                objCls = obj.getClass();
            }
            int argLength = 0;
            int nextIndex = this.size();
            int i = 0;
            while (i < this.size()) {
                Object o = this.get(i);
                if (!(o instanceof String)) {
                    if (((Node)o).getTag() != 6) {
                        nextIndex = i;
                        break;
                    }
                    ++argLength;
                }
                ++i;
            }
            Object[] arg = new Object[argLength];
            int i2 = 0;
            int j = 0;
            while (j < argLength) {
                Object o = this.get(i2);
                if (!(o instanceof String)) {
                    arg[j++] = ((Node)o).getValue(obj);
                }
                ++i2;
            }
            String methodName = this.getAttribute("name");
            Method[] methods = objCls.getMethods();
            int c = 0;
            while (methods != null && c < methods.length) {
                if (methods[c].getName().equals(methodName) && methods[c].getParameterTypes().length == argLength && Modifier.isStatic(methods[c].getModifiers()) == (obj == null) && (obj != null || methods[c].getDeclaringClass() == objCls)) {
                    newObj = null;
                    boolean succeeded = false;
                    try {
                        newObj = methods[c].invoke(obj, arg);
                        succeeded = true;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (succeeded) {
                        this.configure(newObj, nextIndex);
                        return newObj;
                    }
                }
                ++c;
            }
            try {
                Field field = objCls.getField(methodName);
                newObj = field.get(obj);
                this.configure(newObj, nextIndex);
                return newObj;
            }
            catch (Exception exception) {
                throw new IllegalStateException("No Method: " + this.getAttribute("class") + " on " + objCls + "." + methodName);
            }
        }
        catch (Exception e) {
            if (e instanceof ConfigureException) {
                throw (ConfigureException)e;
            }
            throw new ConfigureException(e);
        }
    }
}

