/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.morpho.event.EventListener;
import jp.morpho.event.EventObject;

public class EventTranslator
implements EventListener {
    private static final String METHOD_PREFIX = "on";
    private Object _destination = null;

    public EventTranslator(Object destination) {
        this._destination = destination;
    }

    public synchronized void handleEvent(EventObject event) {
        this.translate(event);
    }

    protected void translate(EventObject event) {
        String methodName = this.getMethodName(event.getType());
        try {
            Method method = this._destination.getClass().getMethod(methodName, event.getClass());
            method.invoke(this._destination, event);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected String getMethodName(String type) {
        String name = type;
        if (name == null || name.length() == 0) {
            return METHOD_PREFIX;
        }
        if (name.length() == 1) {
            return METHOD_PREFIX + name.toUpperCase();
        }
        return METHOD_PREFIX + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

