/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class OutputStreamFactory {
    public synchronized OutputStream getOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public synchronized OutputStream getOutputStream(File file, boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file, append));
    }

    public synchronized OutputStream getOutputStream(String path) throws FileNotFoundException {
        return this.getOutputStream(new File(path));
    }

    public synchronized OutputStream getOutputStream(String path, boolean append) throws FileNotFoundException {
        return this.getOutputStream(new File(path), append);
    }

    public synchronized OutputStream getOutputStream(int size) {
        return new ByteArrayOutputStream(size);
    }

    public synchronized OutputStream getOutputStream(URL url) throws IOException {
        return new BufferedOutputStream(url.openConnection().getOutputStream());
    }
}

