/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.action;

import java.util.Locale;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionHandlerException;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionResponse;

public abstract class BaseActionHandler
implements ActionHandler {
    private HttpActionRequest request = null;

    public void doActionHandler(HttpActionRequest request, HttpActionResponse response, ActionHandlerChain chain) throws ActionHandlerException {
        this.request = request;
    }

    protected FrameworkContext getFrameworkContext() throws ActionHandlerException {
        try {
            return FrameworkContext.getInstance(this.request.getSession().getServletContext());
        }
        catch (FrameworkException e) {
            throw new ActionHandlerException(e.getMessage());
        }
    }

    protected MessageResourceManager getMessageResourceManager() throws ActionHandlerException {
        MessageResourceManager mrm = (MessageResourceManager)this.getFrameworkContext().get("jp.morpho.webapp.resource.MessageResourceManager");
        if (mrm == null) {
            throw new ActionHandlerException("MessageResourceManager is not found.");
        }
        return mrm;
    }

    protected Locale getLocale() {
        Locale locale = (Locale)this.request.getSession().getAttribute("jp.morpho.webapp.servlet.http.HttpSession.locale");
        if (locale == null) {
            locale = this.request.getLocale();
        }
        return locale;
    }

    protected String getMessage(String key, Object[] objs) throws ActionHandlerException {
        return this.getMessageResourceManager().getMessage(key, objs, this.getLocale());
    }

    protected String getMessage(String key) throws ActionHandlerException {
        return this.getMessageResourceManager().getMessage(key, null, this.getLocale());
    }

    protected String getFieldName(String key) throws ActionHandlerException {
        return this.getMessageResourceManager().getFieldName(key, this.getLocale());
    }

    protected ConversionMap getParameterMap() {
        return ConversionMap.valueOf(this.request.getParameterMap());
    }
}

