/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.morpho.io.UploadFile;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.servlet.AbstractFilter;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;

public class FormDataParseFilter
extends AbstractFilter {
    Logger log;
    private static final String INITPARAM_UPLOADDIRECTORY = "uploadDirectory";
    private static final String INITPARAM_BUFFERSIZE = "bufferSize";
    private static final int DEFAULT_BUFFERSIZE = 8192;
    private static final String DEFAULT_CHARACTERENCODING_TO = "Windows-31J";
    private static final String INITPARAM_CHARACTERENCODING = "characterEncoding";
    private static final String DEFAULT_CHARACTERENCODING = "ISO-8859-1";
    private static final int PARTTYPE_TEXT = 1;
    private static final int PARTTYPE_FILE = 2;
    private static final int STATUS_CONTENT_HEADER = 1;
    private static final int STATUS_CONTENT_BODY = 2;
    static /* synthetic */ Class class$0;

    public FormDataParseFilter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.webapp.servlet.FormDataParseFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpActionRequest actioinRequest = HttpActionRequestFactory.getInstance(((HttpServletRequest)request).getSession().getServletContext()).getRequest((HttpServletRequest)request);
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        try {
            ConversionMap parameters = ConversionMap.valueOf(this.getInitParameterMap());
            String characterEncoding = parameters.getString(INITPARAM_CHARACTERENCODING);
            if (characterEncoding == null || characterEncoding.trim().length() == 0) {
                characterEncoding = DEFAULT_CHARACTERENCODING_TO;
            }
            request.setCharacterEncoding(characterEncoding);
            if (contentType == null || !contentType.toLowerCase().startsWith("multipart/form-data")) {
                this.getParameters(actioinRequest);
            } else {
                this.parseMultipartFormData(actioinRequest);
            }
            FrameworkContext fc = FrameworkContext.getInstance(this.getServletContext());
            ActionMappingManager amm = (ActionMappingManager)fc.get("jp.morpho.webapp.action.ActionMappingManager");
            String status = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getStatusParameterName());
            String action = ((ConversionMap)actioinRequest.getParameterMap()).getString(amm.getActionParameterName());
            actioinRequest.setStatus(status);
            actioinRequest.setAction(action);
            ((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getStatusParameterName());
            ((ConversionMap)actioinRequest.getParameterMap()).remove(amm.getActionParameterName());
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, e.getMessage(), e);
        }
        chain.doFilter(request, response);
    }

    protected void getParameters(HttpActionRequest actioinRequest) {
        ConversionMap formValue = new ConversionMap();
        Enumeration paramNames = actioinRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = actioinRequest.getParameterValues(paramName);
            if (paramValues.length > 1) {
                formValue.putObject(paramName, paramValues);
                continue;
            }
            formValue.putString(paramName, paramValues[0]);
        }
        actioinRequest.setParameterMap(formValue);
    }

    protected void parseMultipartFormData(HttpActionRequest actioinRequest) throws IOException {
        int len;
        String CONST_BOUNDARY = "boundary=";
        String CONST_CONTENT_DISPOSITION = "content-disposition:";
        String CONST_NAME = "name=\"";
        String CONST_FILENAME = "filename=\"";
        String CONST_CONTENT_TYPE = "content-type: ";
        ConversionMap form = new ConversionMap();
        byte[] boundary = null;
        int sPos = actioinRequest.getContentType().indexOf("boundary=");
        if (sPos == -1) {
            throw new IOException("Invalid form data");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("--");
        buf.append(actioinRequest.getContentType().substring(sPos + "boundary=".length()));
        boundary = buf.toString().getBytes(DEFAULT_CHARACTERENCODING);
        ConversionMap parameters = ConversionMap.valueOf(this.getInitParameterMap());
        File uploadDirectory = null;
        if (parameters.getString(INITPARAM_UPLOADDIRECTORY).length() == 0) {
            uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
        } else {
            uploadDirectory = new File(parameters.getString(INITPARAM_UPLOADDIRECTORY));
            if (!uploadDirectory.canWrite()) {
                uploadDirectory = new File(System.getProperty("java.io.tmpdir"));
            }
        }
        ServletInputStream in = actioinRequest.getInputStream();
        int bufferSize = parameters.getInt(INITPARAM_BUFFERSIZE);
        if (parameters.getInt(INITPARAM_BUFFERSIZE) <= 0) {
            bufferSize = 8192;
        }
        if (bufferSize < boundary.length + 4) {
            bufferSize = boundary.length + 4;
        }
        byte[] buff = new byte[bufferSize];
        int status = 0;
        int partType = 0;
        ByteArrayOutputStream headerBuf = null;
        String name = null;
        String fileName = null;
        String contentType = null;
        File tempFile = null;
        OutputStream out = null;
        boolean cRLF = false;
        while ((len = in.readLine(buff, 0, buff.length)) != -1) {
            if (this.isBoundary(boundary, buff)) {
                if (status == 2) {
                    Object o = null;
                    if (partType == 1) {
                        byte[] b = ((ByteArrayOutputStream)out).toByteArray();
                        o = new String(b, 0, b.length, actioinRequest.getCharacterEncoding());
                        this.log.finest("form-data." + name + "=" + o);
                    } else {
                        out.close();
                        o = new UploadFile(tempFile.getAbsolutePath());
                        ((UploadFile)o).setUploadPath(fileName);
                        ((UploadFile)o).setContentType(contentType);
                        this.log.finest("form-data." + name + "=" + ((UploadFile)o).getAbsolutePath());
                    }
                    if (form.containsKey(name)) {
                        ArrayList<Object> list = null;
                        if (form.isArray(name)) {
                            list = new ArrayList<Object>(Arrays.asList((Object[])form.get(name)));
                        } else {
                            list = new ArrayList<Object>();
                            list.add(form.get(name));
                        }
                        list.add(o);
                        Object[] objects = null;
                        objects = partType == 1 ? new String[list.size()] : new UploadFile[list.size()];
                        form.putObject(name, list.toArray(objects));
                    } else {
                        form.put(name, o);
                    }
                }
                if (len == boundary.length + 4 && buff[boundary.length] == 45 && buff[boundary.length + 1] == 45) break;
                status = 1;
                headerBuf = null;
                name = null;
                fileName = null;
                contentType = null;
                tempFile = null;
                out = null;
                cRLF = false;
                continue;
            }
            if (status == 1) {
                if (headerBuf == null) {
                    headerBuf = new ByteArrayOutputStream();
                }
                headerBuf.write(buff, 0, len);
                if (len < 2 || buff[len - 2] != 13 || buff[len - 1] != 10) continue;
                String headerField = headerBuf.toString(actioinRequest.getCharacterEncoding());
                headerBuf = null;
                if (headerField.toLowerCase().indexOf("content-disposition:") != -1) {
                    int sPos2 = headerField.toLowerCase().indexOf("name=\"");
                    int ePos = headerField.toLowerCase().indexOf("\"", sPos2 += "name=\"".length());
                    name = headerField.substring(sPos2, ePos);
                    sPos2 = headerField.toLowerCase().indexOf("filename=\"");
                    if (sPos2 == -1) continue;
                    ePos = headerField.toLowerCase().indexOf("\"", sPos2 += "filename=\"".length());
                    fileName = headerField.substring(sPos2, ePos);
                    continue;
                }
                if (headerField.toLowerCase().indexOf("content-type: ") != -1) {
                    int sPos3 = headerField.toLowerCase().indexOf("content-type: ");
                    if (sPos3 == -1) continue;
                    contentType = headerField.substring(sPos3 += "content-type: ".length(), headerField.length() - 2);
                    continue;
                }
                if (!headerField.equals("\r\n")) continue;
                status = 2;
                if (fileName == null) {
                    partType = 1;
                    out = new ByteArrayOutputStream();
                    continue;
                }
                partType = 2;
                tempFile = File.createTempFile("" + new Date().getTime(), null, uploadDirectory);
                tempFile.deleteOnExit();
                out = new FileOutputStream(tempFile);
                continue;
            }
            if (status != 2) continue;
            if (cRLF) {
                cRLF = false;
                out.write(new byte[]{13, 10});
            }
            if (len >= 2 && buff[len - 2] == 13 && buff[len - 1] == 10) {
                cRLF = true;
                out.write(buff, 0, len - 2);
                continue;
            }
            out.write(buff, 0, len);
        }
        actioinRequest.setParameterMap(form);
    }

    private boolean isBoundary(byte[] boundary, byte[] b) {
        int i = 0;
        while (i < boundary.length) {
            if (boundary[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

