/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.LengthValidator;
import jp.morpho.webapp.validator.ValidationException;

public class AlphaValidator
extends LengthValidator {
    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        int bytes = value.getBytes().length;
        int length = value.length();
        if (length != bytes) {
            throw new ValidationException("value is not singlebyte");
        }
        boolean permitCharcheck = this.isPermitCharactersSet();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z')) {
                if (!permitCharcheck) {
                    throw new ValidationException("value is not alphabet");
                }
                if (this.getPermitCharacters().indexOf(c) == -1) {
                    throw new ValidationException("value is not permit character");
                }
            }
            ++i;
        }
        super.validate(request);
    }
}

