/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class DoubleValidator
extends AbstractComparableFieldValidator {
    private Double minimum = null;
    private Double maximum = null;
    private Integer maximumFractionDigits = null;
    private Integer minimumFractionDigits = null;
    private Integer maximumIntegerDigits = null;
    private Integer minimumIntegerDigits = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        int digits;
        int i;
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        double number = 0.0;
        try {
            number = Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not double");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.isMinimumIntegerDigitsSet()) {
            i = value.indexOf(".");
            digits = 0;
            digits = i == -1 ? value.trim().length() : (i == 0 ? 0 : value.substring(0, i).trim().length());
            if (digits < this.getMinimumIntegerDigits()) {
                throw new ValidationException("out of range");
            }
        }
        if (this.isMaximumIntegerDigitsSet()) {
            i = value.indexOf(".");
            digits = 0;
            digits = i == -1 ? value.trim().length() : (i == 0 ? 0 : value.substring(0, i).trim().length());
            if (digits > this.getMaximumIntegerDigits()) {
                throw new ValidationException("out of range");
            }
        }
        if (this.isMinimumFractionDigitsSet()) {
            i = value.indexOf(".");
            digits = 0;
            digits = i == -1 ? 0 : (i == value.length() - 1 ? 0 : value.substring(i + 1).trim().length());
            if (digits < this.getMinimumFractionDigits()) {
                throw new ValidationException("out of range");
            }
        }
        if (this.isMaximumFractionDigitsSet()) {
            i = value.indexOf(".");
            digits = 0;
            digits = i == -1 ? 0 : (i == value.length() - 1 ? 0 : value.substring(i + 1).trim().length());
            if (digits > this.getMaximumFractionDigits()) {
                throw new ValidationException("out of range");
            }
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            double compareValue = Double.parseDouble(this.getFieldValueAsString(request, this.getCompareFieldName()));
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (!(number > compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (!(number >= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (!(number <= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (!(number < compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(double value) {
        this.minimum = new Double(value);
    }

    public void setMaximum(double value) {
        this.maximum = new Double(value);
    }

    public double getMaximum() {
        return this.maximum != null ? this.maximum : 0.0;
    }

    public double getMinimum() {
        return this.minimum != null ? this.minimum : 0.0;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits != null ? this.maximumFractionDigits : 0;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits != null ? this.maximumIntegerDigits : 0;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits != null ? this.minimumFractionDigits : 0;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits != null ? this.minimumIntegerDigits : 0;
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        if (maximumFractionDigits < 0) {
            maximumFractionDigits = 0;
        }
        this.maximumFractionDigits = new Integer(maximumFractionDigits);
    }

    public void setMaximumIntegerDigits(int maximumIntegerDigits) {
        if (maximumIntegerDigits < 0) {
            maximumIntegerDigits = 0;
        }
        this.maximumIntegerDigits = new Integer(maximumIntegerDigits);
    }

    public void setMinimumFractionDigits(int minimumFractionDigits) {
        if (minimumFractionDigits < 0) {
            minimumFractionDigits = 0;
        }
        this.minimumFractionDigits = new Integer(minimumFractionDigits);
    }

    public void setMinimumIntegerDigits(int minimumIntegerDigits) {
        if (minimumIntegerDigits < 0) {
            minimumIntegerDigits = 0;
        }
        this.minimumIntegerDigits = new Integer(minimumIntegerDigits);
    }

    public boolean isMaximumFractionDigitsSet() {
        return this.maximumFractionDigits != null;
    }

    public boolean isMaximumIntegerDigitsSet() {
        return this.maximumIntegerDigits != null;
    }

    public boolean isMinimumFractionDigitsSet() {
        return this.minimumFractionDigits != null;
    }

    public boolean isMinimumIntegerDigitsSet() {
        return this.minimumIntegerDigits != null;
    }
}

