/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class LengthValidator
extends AbstractComparableFieldValidator {
    private Integer minimum = null;
    private Integer maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        int bytes = value.getBytes().length;
        if (this.minimum != null && this.minimum > bytes) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < bytes) {
            throw new ValidationException("out of range");
        }
        this.compareString(request);
    }

    public void setMinimum(int value) {
        this.minimum = new Integer(value);
    }

    public void setMaximum(int value) {
        this.maximum = new Integer(value);
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

