/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class LongValidator
extends AbstractComparableFieldValidator {
    private Long minimum = null;
    private Long maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        long number = 0L;
        try {
            number = Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not long");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            long compareValue = Long.parseLong(this.getFieldValueAsString(request, this.getCompareFieldName()));
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (number <= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (number < compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (number > compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (number >= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(long value) {
        this.minimum = new Long(value);
    }

    public void setMaximum(long value) {
        this.maximum = new Long(value);
    }

    public long getMaximum() {
        return this.maximum != null ? this.maximum : 0L;
    }

    public long getMinimum() {
        return this.minimum != null ? this.minimum : 0L;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

