/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import jp.morpho.util.BadPaddingException;
import jp.morpho.util.ConversionMap;
import jp.morpho.util.LowerCaseKeyMap;
import jp.morpho.util.PrimitiveHolderMap;

public abstract class Coder {
    Logger log;
    private static final PrimitiveHolderMap implementsMap = new ConversionMap(new LowerCaseKeyMap());
    private int _opmode;
    private static final String TRANSFORMATION_BASE64 = "Base64";
    private static final String TRANSFORMATION_HEX = "Hex";
    public static final int ENCODE_MODE = 1;
    public static final int DECODE_MODE = 2;
    static /* synthetic */ Class class$0;

    static {
        implementsMap.putString(TRANSFORMATION_BASE64, "jp.co.mintjams.util.Base64Coder");
        implementsMap.putString(TRANSFORMATION_HEX, "jp.co.mintjams.util.HexCoder");
    }

    protected Coder(String transformation) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.util.Coder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this._opmode = 0;
    }

    public static final Coder getInstance(String transformation) {
        if (!implementsMap.containsKey(transformation)) {
            throw new IllegalArgumentException("Illegal transformation: " + transformation);
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("jp.morpho.util.Coder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                cl = clazz.getClass().getClassLoader();
            }
            return (Coder)cl.loadClass(implementsMap.getString(transformation)).newInstance();
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.morpho.util.Coder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.getLogger(clazz.getName()).log(Level.FINEST, "Illegal transformation: " + transformation, e);
            throw new IllegalArgumentException("Illegal transformation: " + transformation);
        }
    }

    public abstract void init(int var1);

    public abstract byte[] update(int var1) throws IllegalStateException;

    public abstract byte[] update(byte[] var1) throws IllegalStateException;

    public abstract byte[] update(byte[] var1, int var2, int var3) throws IllegalStateException;

    public abstract byte[] doFinal() throws IllegalStateException, BadPaddingException;

    public abstract byte[] doFinal(int var1) throws IllegalStateException, BadPaddingException;

    public abstract byte[] doFinal(byte[] var1) throws IllegalStateException, BadPaddingException;

    public abstract byte[] doFinal(byte[] var1, int var2, int var3) throws IllegalStateException, BadPaddingException;
}

