/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;
import jp.morpho.webapp.servlet.jsp.tagext.ListTag;
import jp.morpho.webapp.servlet.jsp.tagext.PropertySupportTag;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder;
import jp.morpho.webapp.servlet.jsp.tagext.html.SelectTag;

public class OptionsTag
extends BaseTag
implements PropertySupportTag {
    private ConversionMap property = null;
    private ConversionMap supportedPropertyMap = new ConversionMap();

    public OptionsTag() {
        this.supportedPropertyMap.putString("styleid", "");
        this.supportedPropertyMap.putString("styleclass", "");
        this.supportedPropertyMap.putString("style", "");
        this.supportedPropertyMap.putString("title", "");
        this.supportedPropertyMap.putString("onclick", "");
        this.supportedPropertyMap.putString("ondblclick", "");
        this.supportedPropertyMap.putString("onmousedown", "");
        this.supportedPropertyMap.putString("onmouseup", "");
        this.supportedPropertyMap.putString("onmouseover", "");
        this.supportedPropertyMap.putString("onmousemove", "");
        this.supportedPropertyMap.putString("onmouseout", "");
        this.supportedPropertyMap.putString("onkeypress", "");
        this.supportedPropertyMap.putString("onkeydown", "");
        this.supportedPropertyMap.putString("onkeyup", "");
        this.supportedPropertyMap.putString("lang", "");
        this.supportedPropertyMap.putString("dir", "");
        this.supportedPropertyMap.putString("selected", "");
        this.supportedPropertyMap.putString("disabled", "");
        this.supportedPropertyMap.putString("label", "");
        this.supportedPropertyMap.putString("value", "");
        this.supportedPropertyMap.putString("text", "");
    }

    public String getName() {
        return this.getAttributeMap().getString("name");
    }

    public void setName(String name) {
        this.getAttributeMap().putString("name", name);
    }

    public String getScope() {
        return this.getAttributeMap().getString("scope");
    }

    public void setScope(String scope) {
        this.getAttributeMap().putString("scope", scope);
    }

    protected void onInitialize() throws JspException {
        this.property = new ConversionMap();
    }

    protected int onEndTag() throws JspException {
        StringBuffer buf = new StringBuffer();
        int scope = 1;
        if ("request".equals(this.getScope())) {
            scope = 2;
        } else if ("session".equals(this.getScope())) {
            scope = 3;
        } else if ("application".equals(this.getScope())) {
            scope = 4;
        }
        List list = (List)this.pageContext.getAttribute(this.getName(), scope);
        int i = 0;
        while (i < list.size()) {
            buf.append(this.getOptionTag((Map)list.get(i)));
            ++i;
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(buf.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 6;
    }

    protected void onFinalize() throws JspException {
        this.property = null;
        super.onFinalize();
    }

    protected String getOptionTag(Map ti) throws JspException {
        ConversionMap param;
        ConversionMap tagInfo = ConversionMap.valueOf(ti);
        Tag tag = this.getParent();
        while (!(tag instanceof SelectTag)) {
            if (tag == null) {
                throw new JspException("Parent Tag is not found.");
            }
            tag = tag.getParent();
        }
        SelectTag parent = (SelectTag)tag;
        StringBuffer buf = new StringBuffer();
        buf.append("<option");
        String[] keys = new String[this.property.size()];
        keys = this.property.keySet().toArray(keys);
        HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals("disabled") || keys[i].equals("selected")) {
                if (tagInfo.getBoolean(this.property.getString(keys[i]))) {
                    buf.append(" ").append(keys[i]);
                }
            } else if (keys[i].equals("value")) {
                buf.append(" ").append(keys[i]).append("=\"").append(encoder.encode(tagInfo.getString(this.property.getString(keys[i])))).append("\"");
            } else if (!keys[i].equals("text")) {
                buf.append(" ").append(keys[i]).append("=\"").append(tagInfo.getString(this.property.getString(keys[i]))).append("\"");
            }
            ++i;
        }
        if (!this.property.containsKey("selected") && !(param = ConversionMap.valueOf(this.getParameterMap())).isNull(parent.getName())) {
            if (param.isArray(parent.getName())) {
                String[] values = (String[])param.getObject(parent.getName());
                String val = tagInfo.getString(this.property.getString("value"));
                int i2 = 0;
                while (i2 < values.length) {
                    if (val.equals(values[i2])) {
                        buf.append(" ").append("selected");
                        break;
                    }
                    ++i2;
                }
            } else if (tagInfo.getString(this.property.getString("value")).equals(param.getString(parent.getName()))) {
                buf.append(" ").append("selected");
            }
        }
        buf.append(">");
        buf.append(encoder.encode(tagInfo.getString(this.property.getString("text"))));
        buf.append("</option>");
        return buf.toString();
    }

    protected Map getParameterMap() {
        Map map = null;
        ListTag listTag = null;
        Tag tag = this.getParent();
        while (tag != null) {
            if (tag instanceof ListTag) {
                listTag = (ListTag)tag;
                break;
            }
            tag = tag.getParent();
        }
        if (listTag == null) {
            HttpActionRequest request = HttpActionRequestFactory.getInstance(this.pageContext.getServletContext()).getRequest((HttpServletRequest)this.pageContext.getRequest());
            map = request.getParameterMap();
        } else {
            map = listTag.getRowData();
        }
        return map;
    }

    public String getProperty(String key) {
        if (!this.supportedPropertyMap.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not supported");
        }
        return this.property.getString(key);
    }

    public void setProperty(String key, String value) {
        if (!this.supportedPropertyMap.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not supported");
        }
        this.property.putString(key, value);
    }
}

