/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.util;

public class Base64Encoder {
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public synchronized byte[] encode(byte[] data) {
        int modulus = data.length % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int dataLength = data.length - modulus;
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            int a1 = data[i] & 0xFF;
            int a2 = data[i + 1] & 0xFF;
            int a3 = data[i + 2] & 0xFF;
            bytes[j] = encodingTable[a1 >>> 2 & 0x3F];
            bytes[j + 1] = encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j + 2] = encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j + 3] = encodingTable[a3 & 0x3F];
            i += 3;
            j += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = encodingTable[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }
}

