/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.morpho.util.MapWrapper;
import jp.morpho.util.PrimitiveHolderMap;

public class ConversionMap
extends MapWrapper
implements PrimitiveHolderMap,
Serializable {
    private static final String NULL_STRING = "";

    public ConversionMap(Map map) {
        super(map);
    }

    public ConversionMap() {
        super(new HashMap());
    }

    private Object getKey(Object key) {
        return key;
    }

    public synchronized InputStream getInputStream(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        return null;
    }

    public synchronized void putInputStream(Object key, InputStream value) {
        this.put(key, value);
    }

    public synchronized BigDecimal getBigDecimal(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return new BigDecimal(obj.toString());
        }
        return null;
    }

    public synchronized void putBigDecimal(Object key, BigDecimal value) {
        this.put(key, value);
    }

    public synchronized BigInteger getBigInteger(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return new BigInteger(obj.toString());
        }
        return null;
    }

    public synchronized void putBigInteger(Object key, BigInteger value) {
        this.put(key, value);
    }

    public synchronized boolean getBoolean(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.valueOf(obj.toString());
    }

    public synchronized void putBoolean(Object key, boolean value) {
        this.put(key, new Boolean(value));
    }

    public synchronized byte getByte(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return Byte.valueOf(obj.toString());
        }
        return 0;
    }

    public synchronized void putByte(Object key, byte value) {
        this.put(key, new Byte(value));
    }

    public synchronized byte[] getBytes(Object key) {
        return (byte[])this.get(key);
    }

    public synchronized void putBytes(Object key, byte[] value) {
        this.put(key, value);
    }

    public synchronized char getChar(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return '\u0000';
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj.toString().trim().length() > 0) {
            return obj.toString().toCharArray()[0];
        }
        return '\u0000';
    }

    public synchronized void putChar(Object key, char value) {
        this.put(key, new Character(value));
    }

    public synchronized Reader getReader(Object key) {
        return (Reader)this.get(key);
    }

    public synchronized void putReader(Object key, Reader value) {
        this.put(key, value);
    }

    public synchronized java.util.Date getDate(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return new java.util.Date(((Timestamp)obj).getTime());
        }
        if (obj instanceof Date) {
            return new java.util.Date(((Date)obj).getTime());
        }
        if (obj instanceof Time) {
            return new java.util.Date(((Time)obj).getTime());
        }
        if (obj instanceof java.util.Date) {
            return (java.util.Date)obj;
        }
        try {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(obj.toString());
        }
        catch (Exception exception) {
            try {
                return DateFormat.getDateTimeInstance().parse(obj.toString());
            }
            catch (Exception exception2) {
                try {
                    return new java.util.Date(Timestamp.valueOf(obj.toString()).getTime());
                }
                catch (Exception exception3) {
                    try {
                        return DateFormat.getDateInstance().parse(obj.toString());
                    }
                    catch (Exception exception4) {
                        try {
                            return new java.util.Date(Date.valueOf(obj.toString()).getTime());
                        }
                        catch (Exception exception5) {
                            try {
                                return DateFormat.getTimeInstance().parse(obj.toString());
                            }
                            catch (Exception exception6) {
                                try {
                                    return new java.util.Date(Time.valueOf(obj.toString()).getTime());
                                }
                                catch (Exception exception7) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public synchronized java.util.Date parseDate(Object key, String pattern) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern).parse(obj.toString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public synchronized void putDate(Object key, java.util.Date value) {
        this.put(key, value);
    }

    public synchronized double getDouble(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return Double.valueOf(obj.toString());
        }
        return 0.0;
    }

    public synchronized void putDouble(Object key, double value) {
        this.put(key, new Double(value));
    }

    public synchronized float getFloat(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj.toString().trim().length() > 0) {
            return Double.valueOf(obj.toString()).floatValue();
        }
        return 0.0f;
    }

    public synchronized void putFloat(Object key, float value) {
        this.put(key, new Float(value));
    }

    public synchronized int getInt(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return Double.valueOf(obj.toString()).intValue();
        }
        return 0;
    }

    public synchronized void putInt(Object key, int value) {
        this.put(key, new Integer(value));
    }

    public synchronized long getLong(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return Double.valueOf(obj.toString()).longValue();
        }
        return 0L;
    }

    public synchronized void putLong(Object key, long value) {
        this.put(key, new Long(value));
    }

    public synchronized Object getObject(Object key) {
        return this.get(key);
    }

    public synchronized void putObject(Object key, Object value) {
        this.put(key, value);
    }

    public synchronized short getShort(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj.toString().trim().length() > 0) {
            return Double.valueOf(obj.toString()).shortValue();
        }
        return 0;
    }

    public synchronized void putShort(Object key, short value) {
        this.put(key, new Short(value));
    }

    public synchronized String getString(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public synchronized void putString(Object key, String value) {
        this.put(key, value);
    }

    public static synchronized ConversionMap valueOf(Map map) {
        if (map instanceof ConversionMap) {
            return (ConversionMap)map;
        }
        return new ConversionMap(map);
    }

    public synchronized boolean isArray(Object key) {
        Object obj = this.get(key);
        if (obj == null) {
            return false;
        }
        return this.getObject(key).getClass().isArray();
    }

    public boolean containsKey(Object key) {
        return super.containsKey(this.getKey(key));
    }

    public Object get(Object key) {
        return super.get(this.getKey(key));
    }

    public Object put(Object key, Object value) {
        return super.put(this.getKey(key), value);
    }

    public void putAll(Map map) {
        Object[] keys = map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            this.put(this.getKey(keys[i]), map.get(keys[i]));
            ++i;
        }
    }

    public Object remove(Object key) {
        return super.remove(this.getKey(key));
    }

    public synchronized boolean isNull(Object key) {
        return this.getObject(key) == null;
    }

    public synchronized List getList(Object key) {
        return (List)this.get(key);
    }

    public synchronized void putList(Object key, List value) {
        this.put(key, value);
    }

    public synchronized Map getMap(Object key) {
        return (Map)this.get(key);
    }

    public synchronized void putMap(Object key, Map value) {
        this.put(key, value);
    }
}

