/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.morpho.util.Coder;

public class CoderInputStream
extends FilterInputStream {
    private final Coder coder;
    private final List readBuffer;
    private boolean finalized = false;

    public CoderInputStream(InputStream in, Coder coder) {
        super(in);
        this.coder = coder;
        this.readBuffer = new ArrayList();
        this.finalized = false;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (!this.finalized && this.readBuffer.size() == 0) {
            byte[] b = new byte[128];
            int readLength = this.in.read(b, 0, b.length);
            byte[] coded = null;
            if (readLength == -1) {
                try {
                    this.finalized = true;
                    coded = this.coder.doFinal();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                coded = this.coder.update(b, 0, readLength);
            }
            if (coded != null) {
                int i = 0;
                while (i < coded.length) {
                    this.readBuffer.add(new Byte(coded[i]));
                    ++i;
                }
            }
        }
        if (this.readBuffer.size() == 0) {
            return -1;
        }
        return ((Byte)this.readBuffer.remove(0)).byteValue();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        while (count < len) {
            int cur = this.read();
            if (cur == -1) {
                if (count == 0) {
                    return -1;
                }
                return count;
            }
            b[off + count++] = (byte)cur;
        }
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long count = 0L;
        while (count < n && this.read() != -1) {
            ++count;
        }
        return count;
    }

    public synchronized void mark(int readlimit) {
        throw new IllegalStateException("Mark not supported.");
    }

    public synchronized void reset() throws IOException {
        throw new IllegalStateException("Reset not supported.");
    }

    public void close() throws IOException {
        this.in.close();
        this.readBuffer.clear();
    }
}

