/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import jp.morpho.util.ConversionMap;
import jp.morpho.util.StringTokenizer;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;
import jp.morpho.webapp.servlet.jsp.tagext.PropertySupportTag;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder;

public class HiddensTag
extends BaseTag
implements PropertySupportTag {
    private ConversionMap property = null;
    private ConversionMap supportedPropertyMap = new ConversionMap();

    public HiddensTag() {
        this.supportedPropertyMap.putString("includes", "");
        this.supportedPropertyMap.putString("excludes", "");
    }

    public String getName() {
        return this.getAttributeMap().getString("name");
    }

    public void setName(String name) {
        this.getAttributeMap().putString("name", name);
    }

    public String getScope() {
        return this.getAttributeMap().getString("scope");
    }

    public void setScope(String scope) {
        this.getAttributeMap().putString("scope", scope);
    }

    protected void onInitialize() throws JspException {
        this.property = new ConversionMap();
    }

    protected int onEndTag() throws JspException {
        StringBuffer buf = new StringBuffer();
        Map parameterMap = this.getParameterMap();
        if (parameterMap != null) {
            String includes = this.property.getString("includes");
            StringTokenizer includesTokenizer = new StringTokenizer(includes, ",");
            ConversionMap includesMap = new ConversionMap();
            while (includesTokenizer.hasMoreTokens()) {
                String name = includesTokenizer.nextToken();
                if (name.equals("")) continue;
                includesMap.putString(name, "");
            }
            String excludes = this.property.getString("excludes");
            StringTokenizer excludesTokenizer = new StringTokenizer(excludes, ",");
            ConversionMap excludesMap = new ConversionMap();
            while (excludesTokenizer.hasMoreTokens()) {
                String name = excludesTokenizer.nextToken();
                if (name.equals("")) continue;
                excludesMap.putString(name, "");
            }
            HtmlEncoder encoder = this.getTagManager().getHtmlEncoder();
            ConversionMap tagInfo = ConversionMap.valueOf(parameterMap);
            if (includesMap.size() > 0) {
                String[] keys = new String[includesMap.size()];
                keys = includesMap.keySet().toArray(keys);
                int i = 0;
                while (i < keys.length) {
                    if (tagInfo.containsKey(keys[i])) {
                        buf.append("<input type=\"hidden\"");
                        buf.append(" name=\"").append(keys[i]).append("\"");
                        buf.append(" value=\"").append(encoder.encode(tagInfo.getString(keys[i]))).append("\"");
                        buf.append(">");
                    }
                    ++i;
                }
            } else {
                String[] keys = new String[tagInfo.size()];
                keys = tagInfo.keySet().toArray(keys);
                int i = 0;
                while (i < keys.length) {
                    if (!excludesMap.containsKey(keys[i])) {
                        buf.append("<input type=\"hidden\"");
                        buf.append(" name=\"").append(keys[i]).append("\"");
                        buf.append(" value=\"").append(encoder.encode(tagInfo.getString(keys[i]))).append("\"");
                        buf.append(">");
                    }
                    ++i;
                }
            }
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(buf.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 6;
    }

    protected void onFinalize() throws JspException {
        this.property = null;
        super.onFinalize();
    }

    protected Map getParameterMap() {
        if (!this.getScope().equals("request") && (this.getName() == null || this.getName().equals(""))) {
            return null;
        }
        if (this.getScope().equals("request") && (this.getName() == null || this.getName().equals(""))) {
            return this.pageContext.getRequest().getParameterMap();
        }
        int scope = 1;
        if (this.getScope().equals("request")) {
            scope = 2;
        } else if (this.getScope().equals("session")) {
            scope = 3;
        } else if (this.getScope().equals("application")) {
            scope = 4;
        }
        return (Map)this.pageContext.getAttribute(this.getName(), scope);
    }

    public String getProperty(String key) {
        if (!this.supportedPropertyMap.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not supported");
        }
        return this.property.getString(key);
    }

    public void setProperty(String key, String value) {
        if (!this.supportedPropertyMap.containsKey(key)) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not supported");
        }
        this.property.putString(key, value);
    }
}

