/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.util.ArrayList;
import java.util.Locale;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.FieldValidator;
import jp.morpho.webapp.validator.FieldValidatorEntry;
import jp.morpho.webapp.validator.ValidationException;
import jp.morpho.webapp.validator.ValidationState;

public class ValidatorSequence
extends ArrayList
implements FieldValidator {
    private String name = null;

    public void setFieldName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.name;
    }

    public void validate(HttpActionRequest request) throws ValidationException {
        boolean errorFlag = false;
        try {
            FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
            MessageResourceManager mrm = (MessageResourceManager)fc.get("jp.morpho.webapp.resource.MessageResourceManager");
            int i = 0;
            while (i < this.size()) {
                block8: {
                    FieldValidatorEntry entry = (FieldValidatorEntry)this.get(i);
                    FieldValidator validator = entry.getValidator();
                    String messageId = entry.getMessageId();
                    try {
                        validator.validate(request);
                    }
                    catch (Exception e) {
                        errorFlag = true;
                        if (validator.getFieldName() == null) break block8;
                        String message = null;
                        if (messageId != null) {
                            Locale locale = (Locale)request.getSession().getAttribute("jp.morpho.webapp.servlet.http.HttpSession.locale");
                            if (locale == null) {
                                locale = request.getLocale();
                            }
                            message = mrm.getMessage(messageId, null, locale);
                        }
                        ValidationState vs = ValidationState.getInstance(request);
                        vs.addInvalidField(validator.getFieldName(), message);
                    }
                }
                ++i;
            }
            if (errorFlag) {
                throw new ValidationException("");
            }
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

