/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * @author Kumiko Hiroi
 */
public class ListWrapper implements List
{

	//bv List
	private List wrapped = null;

	public ListWrapper(List list)
	{
		super();

		//List  null ̏ꍇ IllegalArgumentException X[܂
		if (list == null)
		{
			throw new IllegalArgumentException("list must not null");
		}

		this.wrapped = list;
	}

	public int size()
	{
		return wrapped.size();
	}

	public boolean isEmpty()
	{
		return wrapped.isEmpty();
	}

	public boolean contains(Object key)
	{
		return wrapped.contains(key);
	}

	public Iterator iterator()
	{
		return wrapped.iterator();
	}

	public Object[] toArray()
	{
		return wrapped.toArray();
	}

	public Object[] toArray(Object[] arg0)
	{
		return wrapped.toArray(arg0);
	}

	public boolean add(Object value)
	{
		return wrapped.add(value);
	}

	public boolean remove(Object arg0)
	{
		return wrapped.remove(arg0);
	}

	public boolean containsAll(Collection arg0)
	{
		return wrapped.containsAll(arg0);
	}

	public boolean addAll(Collection arg0)
	{
		return wrapped.addAll(arg0);
	}

	public boolean addAll(int arg0, Collection arg1)
	{
		return wrapped.addAll(arg0, arg1);
	}

	public boolean removeAll(Collection arg0)
	{
		return wrapped.removeAll(arg0);
	}

	public boolean retainAll(Collection arg0)
	{
		return wrapped.retainAll(arg0);
	}

	public void clear()
	{
		wrapped.clear();
	}

	public Object get(int arg0)
	{
		return wrapped.get(arg0);
	}

	public Object set(int arg0, Object arg1)
	{
		return wrapped.set(arg0, arg1);
	}

	public void add(int arg0, Object arg1)
	{
		wrapped.add(arg0, arg1);
	}

	public Object remove(int arg0)
	{
		return wrapped.remove(arg0);
	}

	public int indexOf(Object arg0)
	{
		return wrapped.indexOf(arg0);
	}

	public int lastIndexOf(Object arg0)
	{
		return wrapped.lastIndexOf(arg0);
	}

	public ListIterator listIterator()
	{
		return wrapped.listIterator();
	}

	public ListIterator listIterator(int arg0)
	{
		return wrapped.listIterator(arg0);
	}

	public List subList(int arg0, int arg1)
	{
		return wrapped.subList(arg0, arg1);
	}

}
