/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action;

import jp.morpho.webapp.Plugin;

/**
 * <P>
 * t[[NNCAg̃NGXgU蕪ۂɎgp郁\bhꎮ`܂B
 * Ⴆ΃ANVnhr[̎擾Ƃ\bhłB
 * </P>
 * <P>
 * ANV}bsO}l[W̎NXׂ͂āA̕WIȃRXgN^񋟂悤ɂĂB
 * WIȃRXgN^Ƃ́Avoid (Ȃ) RXgN^łB̃RXgN^͋̃ANV}bsO쐬܂B
 * </P>
 * @author Kenichi Fukuda
 */
public interface ActionMappingManager
	extends Plugin
{

	/**
	 * <P>
	 * vXe[^X̃p[^̖OԂ܂B
	 * </P>
	 * @return vXe[^X̃p[^̖O
	 */
	public String getStatusParameterName();

	/**
	 * <P>
	 * vANṼp[^̖OԂ܂B
	 * </P>
	 * @return vANṼp[^̖O
	 */
	public String getActionParameterName();

	/**
	 * <P>
	 * ANVnh`FCԂ܂B
	 * ANVnh`FĆAActionMappingManager  getActionHandlers(servletPath, status, action) \bh getActionView(servletPath, status) \bhĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh`FC
	 */
	public ActionHandlerChain getActionHandlerChain(
		String servletPath, String status, String action);

	/**
	 * <P>
	 * ANVnh̔zԂ܂B
	 * ԂꂽANVnh̔źAANVnh`FC doActionHandler \bhŏɌĂяo܂B
	 * </P>
	 * <P>
	 * ̃\bh́AvANVnh擾邽߂ɁAANVnh`FCĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 * @return ANVnh̔z
	 * @exception ActionMappingNotFoundException NCAgĂяoꂽT[ubg URL AXe[^XAANVgpăANV}bsO擾悤ƂAΉANV}bsO̒`Ȃꍇ
	 */
	public ActionHandler[] getActionHandlers(
		String servletPath, String status, String action)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * ANVr[̃pX (JSP Ȃ) Ԃ܂B
	 * ANVr[́AANVnh`FC doActionHandler \bhŁAANVnhĂяoꂽAɃCN[h܂B
	 * </P>
	 * <P>
	 * Xe[^X̒ĺAANVnhŕύX邱Ƃ邽߁AT[ubgv󂯎̒lƕKv܂B
	 * ̃\bh́AANVnh`FC doActionHandler \bhŁAׂẴANVnhsꂽɌĂяo܂B
	 * </P>
	 * @param servletPath ANV}bsOΉ URL
	 * @param status vXe[^X̒l
	 * @return ANVr[̃pX
	 * @exception ActionMappingNotFoundException NCAgĂяoꂽT[ubg URL AXe[^XgpăANV}bsO擾悤ƂAΉANV}bsO̒`Ȃꍇ
	 */
	public String getActionView(
		String servletPath, String status)
		throws ActionMappingNotFoundException;
}
