/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action.impl;

import java.io.Serializable;

import javax.servlet.RequestDispatcher;

import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionHandlerException;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.action.ActionMappingNotFoundException;
import jp.morpho.webapp.servlet.ServletContextAttributeNames;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionResponse;

/**
 * <P>
 * ActionMappingManager ̎łB
 * ActionMappingManagerImpl ԂANVnh`FCŁAActionHandlerChain ̊{܂B
 * </P>
 * <P>
 * V ActionMappingManager ꍇ́AActionHandlerChain C^tF[X̎ƂẴNXgp邩A܂ V ActionHandlerChain C^tF[XĕKvȃ\bh`܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionHandlerChainImpl
	implements ActionHandlerChain, Serializable
{

	/** ANVnh̔z */
	private ActionHandler[] actionHandlers = null;

	/** ANV}bsO}l[W */
	private ActionMappingManager amm = null;

	/** v󂯎T[ubg̃pX */
	private String servletPath = null;

	/** ɎsANVnh̃CfbNX */
	private int actionHandlerIndex = 0;

	private boolean actionViewCanceled = false;

	/**
	 * <P>
	 * FrameworkContextAdapter 쐬܂B
	 * </P>
	 * @param amm ANV}bsO}l[W
	 * @param servletPath v󂯎T[ubg̃pX
	 * @param status vXe[^X̒l
	 * @param action vANV̒l
	 */
	public ActionHandlerChainImpl(ActionMappingManager amm, String servletPath, String status, String action)
	{
		super();
		try
		{
			this.amm = amm;
			this.servletPath = servletPath;
			actionHandlers = amm.getActionHandlers(servletPath, status, action);
		}
		catch (ActionMappingNotFoundException e)
		{
		}
	}

	/**
	 * <P>
	 * `F[̎̃ANVnhĂяo܂B
	 * ĂяõANVnh`F[̍Ō̃ANVnhłꍇ́AANVr[ɃCN[h܂B
	 * </P>
	 * @param request `F[ɉēnv
	 * @param response `F[ɉēn
	 * @exception ActionHandlerException ANVnh̒ʏ̏WOꍇ
	 * @see jp.morpho.webapp.action.ActionHandlerChain#doActionHandler(HttpActionRequest, HttpActionResponse)
	 */
	public synchronized void doActionHandler(
		HttpActionRequest request,
		HttpActionResponse response)
		throws ActionHandlerException
	{
		//̃ANVnhꍇ
		if (actionHandlerIndex < actionHandlers.length)
		{
			//ɎsANVnh擾܂
			ActionHandler next = actionHandlers[actionHandlerIndex];

			//ɎsANVnh̃CfbNXXV܂
			actionHandlerIndex++;

			//ANVnhs܂
			next.doActionHandler(request, response, this);
		}
		else if (!actionViewCanceled)
		{
			try
			{
				//GR[fBOݒ肵܂
				response.setContentType("text/html; charset=" + request.getSession().getServletContext().getAttribute(ServletContextAttributeNames.characterEncoding));

				//ׂẴANVnhsꂽꍇAɃANVr[CN[h܂
				RequestDispatcher rd = request.getRequestDispatcher(amm.getActionView(servletPath, request.getStatus()));
				rd.include(request, response);
			}
			catch (Exception e)
			{
				throw new ActionHandlerException(e);
			}
		}
	}

	/**
	 * @see jp.morpho.webapp.action.ActionHandlerChain#cancelActionHandlers()
	 */
	public synchronized void cancelActionHandlers()
	{
		actionHandlerIndex = actionHandlers.length;
	}

	/**
	 * @see jp.morpho.webapp.action.ActionHandlerChain#cancelActionView()
	 */
	public synchronized void cancelActionView()
	{
		actionViewCanceled = true;
	}

	/**
	 * @see jp.morpho.webapp.action.ActionHandlerChain#skipActionHandlers(int)
	 */
	public synchronized void skipActionHandlers(int skip)
	{
		if (skip < 1)
		{
			throw new IllegalArgumentException("" + skip);
		}
		if (actionHandlers.length <= actionHandlerIndex + skip)
		{
			throw new IndexOutOfBoundsException("" + (actionHandlerIndex + skip));
		}
		actionHandlerIndex += skip;
	}

}
