/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.http.impl;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import jp.morpho.io.UploadFile;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.ServletRequestAttributeNames;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * HttpActionRequestImpl NX́AHTTP T[ubgp̗v񋟂 HttpActionRequest C^tF[X̎łB
 * ̃NX́Abp[܂̓fR[^̃p^[ɊÂĎĂ܂B
 * e\bh́AbvꂽvIuWFNg̃\bhftHgŌĂяo܂B
 * </P>
 * <P>
 * HttpActionRequestImpl NXɂ́Av邽߂ɕKvȃANVXe[^X擾邽߂̃\bh񋟂܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class HttpActionRequestImpl
	extends HttpServletRequestWrapper
	implements HttpActionRequest
{

	/**
	 * <P>
	 * w肳ꂽvbv HttpActionRequestImpl \z܂B
	 * </P>
	 * @param request T[ubgւ̗v
	 * @exception IllegalArgumentException v null ̏ꍇ
	 */
	public HttpActionRequestImpl(HttpServletRequest request)
	{
		super(request);
	}

	/**
	 * <P>
	 * vANV̒l擾܂B
	 * </P>
	 * @return vANV̒l
	 */
	public String getAction()
	{
		return (String)this.getAttribute(ServletRequestAttributeNames.action);
	}

	/**
	 * <P>
	 * vANV̒lݒ肵܂B
	 * </P>
	 * @param action vANV̒l
	 */
	public void setAction(String action)
	{
		this.setAttribute(ServletRequestAttributeNames.action, action);
	}

	/**
	 * <P>
	 * vXe[^X̒l擾܂B
	 * </P>
	 * @return vXe[^X̒l
	 */
	public String getStatus()
	{
		return (String)this.getAttribute(ServletRequestAttributeNames.status);
	}

	/**
	 * <P>
	 * vXe[^X̒lݒ肵܂B
	 * </P>
	 * @param status vXe[^X̒l
	 */
	public void setStatus(String status)
	{
		this.setAttribute(ServletRequestAttributeNames.status, status);
	}

	/**
	 * <P>
	 * ̗v擾łp[^ java.util.Map ŕԂ܂B
	 * vp[^Ƃ́AvƂƂɑMǉłB
	 * HTTP T[ubg̏ꍇAp[^̓NG[܂ POST ꂽ`̃f[^Ɋi[Ă܂B
	 * </P>
	 * @return L[Ƃăp[^A}bvlƂăp[^li[ꂽ java.util.MapBp[^}bṽL[ String ^Bp[^}bv̒ĺAp[^ 1 ̒l݂̂܂܂Ăꍇ String A̒lp[^̏ꍇ String ̔z^Bp[^̒lAbv[hꂽt@C̏ꍇ jp.morpho.io.UploadFile ܂ jp.morpho.io.UploadFile ̔z^
	 */
	public Map getParameterMap()
	{
		Map formValues = (Map)this.getAttribute(ServletRequestAttributeNames.form);
		if (formValues == null)
		{
			formValues = new ConversionMap();
			this.setParameterMap(formValues);
		}
		return formValues;
	}

	/**
	 * <P>
	 * ̗vɃp[^ݒ肵܂B
	 * </P>
	 * @param map vp[^
	 */
	public void setParameterMap(Map map)
	{
		this.setAttribute(ServletRequestAttributeNames.form, map);
	}

	/**
	 * <P>
	 * ̗vɃp[^̃}bvꍇɁÃp[^̃}bvv폜܂B<br>
	 * </P>
	 */
	public void removeParameterMap()
	{
		this.removeAttribute(ServletRequestAttributeNames.form);
	}

	/**
	 * <P>
	 * vp[^̒l String ƂĕԂ܂B
	 * p[^݂Ȃꍇ́Anull Ԃ܂B
	 * vp[^́AvƂƂɑMǉłB
	 * HTTP T[ubg̏ꍇANG[܂ POST ꂽ`̃f[^Ƀp[^i[Ă܂B
	 * </P>
	 * <P>
	 * p[^ 1 ̒l݂̂܂܂Ă邱Ƃmȏꍇɂ̂݁Ã\bhgpĂB
	 * p[^ɕ̒l܂܂Ă\ꍇ́AgetParameterValues(java.lang.String) gp܂B
	 * </P>
	 * <P>
	 * ̒lp[^ɑ΂Ẵ\bhgpꍇAԂĺAgetParameterValues ŕԂz̍ŏ̒lƓłB
	 * </P>
	 * @param name p[^̖Ow肷 String
	 * @return p[^̒P̒l\ String
	 * @see javax.servlet.ServletRequest#getParameter(String)
	 */
	public String getParameter(String name)
	{
		ConversionMap formValues = ConversionMap.valueOf(this.getParameterMap());

		if (formValues.getObject(name) instanceof UploadFile)
		{
			return null;
		}
		if (formValues.isNull(name))
		{
			return null;
		}
		if (formValues.isArray(name))
		{
			Object[] objs = (Object[])formValues.getObject(name);
			return objs[0].toString();
		}
		return formValues.getString(name);
	}
}
