/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.action.impl;

import java.io.Serializable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.morpho.webapp.action.ActionHandler;
import jp.morpho.webapp.action.ActionHandlerChain;
import jp.morpho.webapp.action.ActionHandlerException;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.action.ActionMappingNotFoundException;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionResponse;

public class ActionHandlerChainImpl
implements ActionHandlerChain,
Serializable {
    private ActionHandler[] actionHandlers = null;
    private ActionMappingManager amm = null;
    private String servletPath = null;
    private int actionHandlerIndex = 0;
    private boolean actionViewCanceled = false;

    public ActionHandlerChainImpl(ActionMappingManager amm, String servletPath, String status, String action) {
        try {
            this.amm = amm;
            this.servletPath = servletPath;
            this.actionHandlers = amm.getActionHandlers(servletPath, status, action);
        }
        catch (ActionMappingNotFoundException actionMappingNotFoundException) {
            // empty catch block
        }
    }

    public synchronized void doActionHandler(HttpActionRequest request, HttpActionResponse response) throws ActionHandlerException {
        if (this.actionHandlerIndex < this.actionHandlers.length) {
            ActionHandler next = this.actionHandlers[this.actionHandlerIndex];
            ++this.actionHandlerIndex;
            next.doActionHandler(request, response, this);
        } else if (!this.actionViewCanceled) {
            try {
                response.setContentType("text/html; charset=" + request.getSession().getServletContext().getAttribute("jp.morpho.webapp.servlet.ServletContext.characterEncoding"));
                RequestDispatcher rd = request.getRequestDispatcher(this.amm.getActionView(this.servletPath, request.getStatus()));
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                throw new ActionHandlerException(e);
            }
        }
    }

    public synchronized void cancelActionHandlers() {
        this.actionHandlerIndex = this.actionHandlers.length;
    }

    public synchronized void cancelActionView() {
        this.actionViewCanceled = true;
    }

    public synchronized void skipActionHandlers(int skip) {
        if (skip < 1) {
            throw new IllegalArgumentException("" + skip);
        }
        if (this.actionHandlers.length <= this.actionHandlerIndex + skip) {
            throw new IndexOutOfBoundsException("" + (this.actionHandlerIndex + skip));
        }
        this.actionHandlerIndex += skip;
    }
}

