/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.resource;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jp.morpho.config.Configuration;
import jp.morpho.util.ConversionList;
import jp.morpho.util.PrimitiveHolderList;
import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.resource.MessageResourceEntry;
import jp.morpho.webapp.resource.MessageResourceException;

public class MessageResourceManager
implements Plugin {
    private PluginContext pluginContext = null;
    private PrimitiveHolderList configPathList = new ConversionList();
    private static final String fieldNameBaseKey = "fieldName.";
    protected ArrayList resourceEntries = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public synchronized void removeAllConfigurationFilePaths() {
        this.configPathList.clear();
    }

    public synchronized void addConfigurationFilePath(String path) {
        this.configPathList.add(path);
    }

    public synchronized String[] getConfigurationFilePaths() {
        String[] paths = new String[this.configPathList.size()];
        return this.configPathList.toArray(paths);
    }

    public synchronized void addMessageResourceEntry(MessageResourceEntry resourceEntry) {
        this.resourceEntries.add(resourceEntry);
    }

    public synchronized String getMessage(String key, Object[] objs, Locale locale) {
        return this.getMessage(key, objs, locale, (String)null);
    }

    public synchronized String getMessage(String key, Object[] objs, Locale locale, String resourceName) {
        if (resourceName != null) {
            int i = 0;
            while (i < this.resourceEntries.size()) {
                MessageResourceEntry resourceEntry = (MessageResourceEntry)this.resourceEntries.get(i);
                if (resourceEntry.getResourceName().equals(resourceName)) {
                    return this.getMessage(key, objs, locale, resourceEntry);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.resourceEntries.size()) {
                MessageResourceEntry resourceEntry = (MessageResourceEntry)this.resourceEntries.get(i);
                try {
                    return this.getMessage(key, objs, locale, resourceEntry);
                }
                catch (Exception exception) {
                    ++i;
                }
            }
        }
        throw new MessageResourceException("Can't find resource for key=" + key);
    }

    protected String getMessage(String key, Object[] objs, Locale locale, MessageResourceEntry entry) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        String baseName = entry.getBaseName();
        String className = entry.getClassName();
        Class<?> cls = null;
        try {
            cls = cl.loadClass(className);
        }
        catch (Exception e) {
            throw new MessageResourceException(e.getMessage());
        }
        Method method = null;
        try {
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.util.Locale");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            method = cls.getMethod("getBundle", classArray);
        }
        catch (Exception e) {
            throw new MessageResourceException(e.getMessage());
        }
        ResourceBundle rb = null;
        try {
            rb = (ResourceBundle)method.invoke(cls, baseName, locale, cl);
        }
        catch (Exception e) {
            throw new MessageResourceException(e.getMessage());
        }
        try {
            String msg = rb.getString(key);
            if (objs == null) {
                return msg;
            }
            try {
                MessageFormat mf = new MessageFormat(msg);
                return mf.format(objs);
            }
            catch (Exception e) {
                throw new MessageResourceException(e.getMessage());
            }
        }
        catch (MessageResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageResourceException(e.getMessage());
        }
    }

    public synchronized String getFieldName(String key, Locale locale) {
        return this.getMessage(fieldNameBaseKey + key, null, locale);
    }

    public final String getPluginKey() {
        return "jp.morpho.webapp.resource.MessageResourceManager";
    }

    public void setPluginContext(PluginContext fc) throws PluginException {
        this.pluginContext = fc;
    }

    public void pluginActivate() throws PluginException {
        ServletContext sc = this.pluginContext.getFrameworkContext().getServletContext();
        String[] paths = this.getConfigurationFilePaths();
        int i = 0;
        while (i < paths.length) {
            Exception e3;
            Object var7_8;
            InputStream in = null;
            try {
                try {
                    URL url = sc.getResource(paths[i]);
                    in = url.openStream();
                    Configuration config = new Configuration();
                    config.configure(this, in);
                }
                catch (Exception e2) {
                    Logger log = Logger.getLogger("jp.morpho");
                    log.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    in.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var7_8 = null;
            try {
                in.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            ++i;
        }
    }

    public void pluginRemove() throws PluginException {
        this.pluginContext = null;
    }
}

