/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet.jsp.tagext;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jp.morpho.config.Configuration;
import jp.morpho.util.ConversionList;
import jp.morpho.util.PrimitiveHolderList;
import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.servlet.jsp.tagext.TagTemplate;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder;
import jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoderImpl;

public class TagManager
implements Plugin {
    private PluginContext pluginContext = null;
    private PrimitiveHolderList configPathList = new ConversionList();
    private Map tagTemplateMap = new HashMap();
    private HtmlEncoder htmlEncoder = null;
    private static final String NULL_NAME = "";
    private static final String NULL_TAGTYPE = "";

    public TagManager() {
        this.setHtmlEncoder(new HtmlEncoderImpl());
    }

    public synchronized void removeAllConfigurationFilePaths() {
        this.configPathList.clear();
    }

    public synchronized void addConfigurationFilePath(String path) {
        this.configPathList.add(path);
    }

    public synchronized String[] getConfigurationFilePaths() {
        String[] paths = new String[this.configPathList.size()];
        return this.configPathList.toArray(paths);
    }

    public synchronized String generateTagTemplateKey(String tagType, String name) {
        StringBuffer buf = new StringBuffer();
        buf.append("TagTemplate[");
        buf.append("tagType=").append(tagType != null ? tagType : "");
        buf.append(",");
        buf.append("name=").append(name != null ? name : "");
        buf.append("]");
        return buf.toString();
    }

    public synchronized void addTagTemplate(TagTemplate fe) {
        String key = this.generateTagTemplateKey(fe.getTagType(), fe.getName());
        if (this.tagTemplateMap.containsKey(key)) {
            throw new IllegalArgumentException("TagTemplate already exists: " + key);
        }
        this.tagTemplateMap.put(key, fe);
    }

    public synchronized TagTemplate getTagTemplate(String tagType, String name) {
        String key = this.generateTagTemplateKey(tagType, name);
        return (TagTemplate)this.tagTemplateMap.get(key);
    }

    public final String getPluginKey() {
        return "jp.morpho.webapp.servlet.jsp.tagext.TagManager";
    }

    public HtmlEncoder getHtmlEncoder() {
        return this.htmlEncoder;
    }

    public void setHtmlEncoder(HtmlEncoder htmlEncoder) {
        this.htmlEncoder = htmlEncoder;
    }

    public void setPluginContext(PluginContext fc) throws PluginException {
        this.pluginContext = fc;
    }

    public void pluginActivate() throws PluginException {
        ServletContext sc = this.pluginContext.getFrameworkContext().getServletContext();
        String[] paths = this.getConfigurationFilePaths();
        int i = 0;
        while (i < paths.length) {
            Exception e3;
            Object var7_8;
            InputStream in = null;
            try {
                try {
                    URL url = sc.getResource(paths[i]);
                    in = url.openStream();
                    Configuration config = new Configuration();
                    config.configure(this, in);
                }
                catch (Exception e2) {
                    Logger log = Logger.getLogger("jp.morpho");
                    log.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    in.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var7_8 = null;
            try {
                in.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            ++i;
        }
    }

    public void pluginRemove() throws PluginException {
        this.pluginContext = null;
    }
}

