/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class FloatValidator
extends AbstractFieldValidator {
    private Float minimum = null;
    private Float maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = request.getParameter(this.getFieldName());
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        float number = 0.0f;
        try {
            number = Float.parseFloat(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not float");
        }
        if (this.minimum != null && this.minimum.floatValue() > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum.floatValue() < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
            float compareValue = form.getFloat(this.getCompareFieldName());
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (!(number > compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (!(number >= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (!(number <= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (!(number < compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(float value) {
        this.minimum = new Float(value);
    }

    public void setMaximum(float value) {
        this.maximum = new Float(value);
    }

    public float getMaximum() {
        return this.maximum != null ? this.maximum.floatValue() : 0.0f;
    }

    public float getMinimum() {
        return this.minimum != null ? this.minimum.floatValue() : 0.0f;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

