/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import org.xml.sax.Attributes;

/**
 * <P>
 * AddNode NX́Aadd ^O\܂B
 * add ^Oɂ́A#PCDATA Acall Anew  SystemProperty ^O܂߂邱Ƃł܂B
 * </P>
 * <P>
 * Ⴆ add ^ÓÂ悤ɔzLqqɋLq܂B
 * </P>
 * <P>
 * <PRE>
 *     &lt;add name="someMethod"&gt;someValue&lt;/add&gt;
 * </PRE>
 * </P>
 * <P>
 * ́Â悤ȃR[hƂƓłB
 * </P>
 * <P>
 * <PRE>
 *     obj.addSomeMethod("someValue");
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class AddNode extends SetNode
{

	/**
	 * <P>
	 * em[hƃm[h̑w肵 AddNode IuWFNg쐬܂B
	 * </P>
	 * @param parent ̃m[h̐em[h
	 * @param attributes ̃m[h̑
	 */
	public AddNode(Node parent, Attributes attributes)
	{
		super(parent, attributes, "add");
	}

	/**
	 * <P>
	 * ^OlԂ܂B
	 * </P>
	 * @return ^Ol
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.ADD;
	}

}
