/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;


/**
 * <P>
 * NodeTypes NX́ANode f[^^ʂ邽߂ɎgpNXłB
 * </P>
 * @author Kumiko Hiroi
 */
public class NodeTypes
{
//------------------------------------------------------------------------------
//tB[h
//------------------------------------------------------------------------------

	/** Node SET ^ʂ܂B */
	public static final int SET				= 0x01;

	/** Node GET ^ʂ܂B */
	public static final int GET				= 0x02;

	/** Node CALL ^ʂ܂B */
	public static final int CALL			= 0x03;

	/** Node PUT ^ʂ܂B */
	public static final int PUT		= 0x04;

	/** Node NEW ^ʂ܂B */
	public static final int NEW				= 0x05;

	/** Node ARG ^ʂ܂B */
	public static final int ARG	= 0x06;

	/** Node SYSTEMPROPERTY ^ʂ܂B */
	public static final int SYSTEMPROPERTY	= 0x07;

	/** Node CONFIGURE ^ʂ܂B */
	public static final int CONFIGURE	= 0x08;

	/** Node ADD ^ʂ܂B */
	public static final int ADD	= 0x09;

	/**
	 * <P>
	 * ^O̖OԂ܂B
	 * </P>
	 * @param tag ^Ol
	 * @return ^O̖O
	 */
	static public String getName(int tag)
	{
		switch (tag)
		{
			case SET:
				return "set";
			case GET:
				return "get";
			case CALL:
				return "call";
			case PUT:
				return "put";
			case NEW:
				return "new";
			case ARG:
				return "arg";
			case SYSTEMPROPERTY:
				return "SystemProperty";
			case CONFIGURE:
				return "configure";
			case ADD:
				return "add";
			default:
				return "";
		}
	}

	/**
	 * <P>
	 * ^OlԂ܂B
	 * </P>
	 * @param name ^O̖O
	 * @return ^Ol
	 */
	static public int getTag(String name)
	{
		if ("set".equals(name))
		{
			return SET;
		}
		else if ("get".equals(name))
		{
			return GET;
		}
		else if ("call".equals(name))
		{
			return CALL;
		}
		else if ("put".equals(name))
		{
			return PUT;
		}
		else if ("new".equals(name))
		{
			return NEW;
		}
		else if ("arg".equals(name))
		{
			return ARG;
		}
		else if ("SystemProperty".equals(name))
		{
			return SYSTEMPROPERTY;
		}
		else if ("configure".equals(name))
		{
			return CONFIGURE;
		}
		else if ("add".equals(name))
		{
			return ADD;
		}
		else
		{
			throw new IllegalStateException("Unknown tag: " + name);
		}
	}
}
