/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

/**
 * <P>
 * o̓Xg[t@Ng̋@\`܂B
 * o̓Xg[t@NǵAo̓Xg[t@CApXAoCgz̃TCYAURL Ȃǂ̃IuWFNg琶邽߂Ɏgp܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class OutputStreamFactory
{

	/**
	 * <P>
	 * OutputStreamFactory IuWFNg쐬܂B
	 * </P>
	 */
	public OutputStreamFactory()
	{
		super();
	}

	/**
	 * <P>
	 * w肳ꂽ File IuWFNgŕ\t@Cɏނ߂̃t@Co̓Xg[쐬܂B
	 * ̃t@Cڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckWrite \bh file ɂĕ\pXƂČĂяo܂B
	 * </P>
	 * <P>
	 * t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param file ݂̂߂ɊJt@C
	 * @return t@Cɏނ߂̃t@Co̓Xg[ (BufferedOutputStream)
	 * @exception FileNotFoundException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckWrite \bht@Cւ̏݃ANZXۂꍇ
	 */
	public synchronized OutputStream getOutputStream(File file) throws FileNotFoundException
	{
		return new BufferedOutputStream(new FileOutputStream(file));
	}

	/**
	 * <P>
	 * w肳ꂽ File IuWFNg\t@Cɏނ߂̏o̓t@CXg[쐬܂B
	 * 2 Ԗڂ̈ true ̏ꍇAoCg̓t@C̐擪ł͂ȂŌɏ܂܂B
	 * ̃t@Cڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckWrite \bh file ɂĕ\pXƂČĂяo܂B
	 * </P>
	 * <P>
	 * t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param file ݂̂߂ɊJt@C
	 * @param append true ̏ꍇAoCg̓t@C̐擪ł͂ȂŌɏ܂
	 * @return t@Cɏނ߂̃t@Co̓Xg[ (BufferedOutputStream)
	 * @exception FileNotFoundException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckWrite \bht@Cւ̏݃ANZXۂꍇ
	 */
	public synchronized OutputStream getOutputStream(File file, boolean append) throws FileNotFoundException
	{
		return new BufferedOutputStream(new FileOutputStream(file, append));
	}

	/**
	 * <P>
	 * w肳ꂽ path ̃t@Cɏނ߂̏o̓t@CXg[쐬܂B
	 * ̃t@Cڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckWrite \bh name ƂČĂяo܂B
	 * </P>
	 * <P>
	 * t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param path VXeɈˑt@C
	 * @return t@Cɏނ߂̃t@Co̓Xg[ (BufferedOutputStream)
	 * @exception FileNotFoundException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckWrite \bht@Cւ̏݃ANZXۂꍇ
	 */
	public synchronized OutputStream getOutputStream(String path) throws FileNotFoundException
	{
		return getOutputStream(new File(path));
	}

	/**
	 * <P>
	 * w肳ꂽ path ̃t@Cɏނ߂̏o̓t@CXg[쐬܂B
	 * 2 Ԗڂ̈ true ̏ꍇAoCg̓t@C̐擪ł͂ȂŌɏ܂܂B
	 * ̃t@Cڑ\߂ɁAV FileDescriptor IuWFNg܂B
	 * </P>
	 * <P>
	 * ܂AZLeB}l[W݂ꍇAcheckWrite \bh name ƂČĂяo܂B
	 * </P>
	 * <P>
	 * t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ́AFileNotFoundException X[܂B
	 * </P>
	 * @param path VXeɈˑt@C
	 * @param append true ̏ꍇAoCg̓t@C̐擪ł͂ȂŌɏ܂
	 * @return t@Cɏނ߂̃t@Co̓Xg[ (BufferedOutputStream)
	 * @exception FileNotFoundException t@C݂͑邪Aʂ̃t@Cł͂ȂfBNgłꍇAt@C݂͑쐬łȂꍇA܂͂Ȃ炩̗RŊJƂłȂꍇ
	 * @exception SecurityException ZLeB}l[W݂AcheckWrite \bht@Cւ̏݃ANZXۂꍇ
	 */
	public synchronized OutputStream getOutputStream(String path, boolean append) throws FileNotFoundException
	{
		return getOutputStream(new File(path), append);
	}

	/**
	 * <P>
	 * oCgŎw肳ꂽTCỸobt@AoCgzo̓Xg[V쐬܂B
	 * </P>
	 * @param size TCY
	 * @return oCgzo̓Xg[ (ByteArrayOutputStream)
	 */
	public synchronized OutputStream getOutputStream(int size)
	{
		return new ByteArrayOutputStream(size);
	}

	/**
	 * <P>
	 * url ւ̐ڑmA̐ڑɏ݂so̓Xg[쐬܂B
	 * </P>
	 * @param url URL
	 * @return URL ڑɏ݂so̓Xg[ (BufferedOutputStream)
	 * @exception IOException o͗Oꍇ
	 * @exception UnknownServiceException vgRo͂T|[gĂȂꍇ
	 */
	public synchronized OutputStream getOutputStream(URL url) throws IOException
	{
		return new BufferedOutputStream(url.openConnection().getOutputStream());
	}
}
