/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import jp.morpho.util.ConversionMap;
import jp.morpho.util.PrimitiveHolderMap;
import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.action.ActionMappingManager;
import jp.morpho.webapp.resource.MessageResourceManager;

/**
 * <P>
 * ^Onh`邽߂̊NXłB
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class BaseTag
	extends BodyTagSupport
{
	private ConversionMap attrs = new ConversionMap();
	private boolean bodyExists = false;

	/**
	 * <P>
	 * ftHg̃RXgN^łB
	 * ׂẴTuNX́AVOj`[ public RXgN^`AX[p[NX̃RXgN^ĂяoKv܂B
	 * ̃RXgN^́AJSP gX[^ɂĐꂽR[hĂяo܂B
	 * </P>
	 */
	public BaseTag()
	{
		super();
	}

	/**
	 * <P>
	 * ^O擾ł鑮 jp.morpho.util.PrimitiveHolderMap ŕԂ܂B
	 * </P>
	 * @return L[ƂđA}bvlƂđli[ꂽ jp.morpho.util.PrimitiveHolderMapB}bṽL[ƒl String ^
	 */
	public PrimitiveHolderMap getAttributeMap()
	{
		return this.attrs;
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		this.getAttributeMap().clear();
		this.bodyExists = false;
		return super.doEndTag();
	}

	/**
	 * <P>
	 * ĂяoݎsĂ ServletContext Ɋi[Ă FrameworkContext IuWFNgւ̎QƂ擾܂B
	 * </P>
	 * @return ĂяoT[ubgReiƂ̑Θb̂߂ɎgpĂ ServletContext IuWFNgɊi[Ă FrameworkContext IuWFNg
	 */
	protected FrameworkContext getFrameworkContext() throws JspException
	{
		FrameworkContext fc;
		try
		{
			fc = FrameworkContext.getInstance(((HttpServletRequest)pageContext.getRequest()).getSession().getServletContext());
		}
		catch (FrameworkException e)
		{
			throw new JspException(e.getMessage());
		}
		return fc;
	}

	/**
	 * <P>
	 * ĂяoݎsĂ ServletContext Ɋi[Ă FrameworkContext IuWFNgATagManager 擾܂B
	 * </P>
	 * @return TagManager IuWFNg
	 */
	protected TagManager getTagManager() throws JspException
	{
		FrameworkContext fc = this.getFrameworkContext();
		TagManager tm = (TagManager)fc.get(PluginKeys.tagManager);
		if (tm == null)
		{
			throw new JspException("TagManager is not found.");
		}
		return tm;
	}

	/**
	 * <P>
	 * ĂяoݎsĂ ServletContext Ɋi[Ă FrameworkContext IuWFNgAActionMappingManager 擾܂B
	 * </P>
	 * @return ActionMappingManager IuWFNg
	 */
	protected ActionMappingManager getActionMappingManager() throws JspException
	{
		FrameworkContext fc = this.getFrameworkContext();
		ActionMappingManager amm = (ActionMappingManager)fc.get(PluginKeys.actionMappingManager);
		if (amm == null)
		{
			throw new JspException("ActionMappingManager is not found.");
		}
		return amm;
	}

	/**
	 * <P>
	 * ĂяoݎsĂ ServletContext Ɋi[Ă FrameworkContext IuWFNgAMessageResourceManager 擾܂B
	 * </P>
	 * @return MessageResourceManager IuWFNg
	 */
	protected MessageResourceManager getMessageResourceManager() throws JspException
	{
		FrameworkContext fc = this.getFrameworkContext();
		MessageResourceManager mrm = (MessageResourceManager)fc.get(PluginKeys.messageResourceManager);
		if (mrm == null)
		{
			throw new JspException("MessageResourceManager is not found.");
		}
		return mrm;
	}

	/**
	 * <P>
	 * ^O{̂]ɁAĕ]s킸ɁAy[W𑱍s܂B
	 * </P>
	 * @return SKIP_BODY
	 * @see javax.servlet.jsp.tagext.IterationTag#doAfterBody()
	 */
	public int doAfterBody() throws JspException
	{
		bodyExists = true;
		if (bodyContent.getString().length() > 0)
		{
			try
			{
				bodyContent.writeOut(bodyContent.getEnclosingWriter());
			}
			catch (IOException e)
			{
				throw new JspException(e.getMessage());
			}
		}
		return SKIP_BODY;
	}

	/**
	 * <P>
	 * ^O{̂ꍇ true Ԃ܂B
	 * </P>
	 * @return ^O{̂ꍇ true
	 */
	public boolean isBodyExists()
	{
		return bodyExists;
	}

}
