/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * <P>
 * SELECT vfɂč쐬ꂽj[̑IłB
 * w肳ꂽXR[v̑ɐݒ肳Ă郊Xg畡 OPTION vf쐬܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class PropertyTag
	extends BaseTag
{

	/**
	 * <P>
	 * OptionTag 쐬܂B
	 * </P>
	 */
	public PropertyTag()
	{
		super();
	}

	/**
	 * <P>
	 * key Ԃ܂B
	 * </P>
	 * @return key 
	 */
	public String getKey()
	{
		return getAttributeMap().getString("key");
	}

	/**
	 * <P>
	 * key ݒ肵܂B
	 * </P>
	 * @param key key 
	 */
	public void setKey(String key)
	{
		getAttributeMap().putString("key", key);
	}

	/**
	 * <P>
	 * ^O{̂]ɁAĕ]s킸ɁAy[W𑱍s܂B
	 * ftHgł́AbodyContent ̃f[^ (݂ꍇ) ͑삵܂B
	 * </P>
	 * @return SKIP_BODY
	 * @see javax.servlet.jsp.tagext.IterationTag#doAfterBody()
	 */
	public int doAfterBody() throws JspException
	{
		Tag tag = this.getParent();
		while (!(tag instanceof PropertySupportTag))
		{
			if (tag == null)
			{
				throw new JspException("Parent Tag is not found.");
			}
			tag = tag.getParent();
		}
		PropertySupportTag parent = (PropertySupportTag)tag;

		parent.setProperty(this.getKey(), bodyContent.getString());

		return SKIP_BODY;
	}

}
