/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;


/**
 * <P>
 * THEAD ATFOOT ATBODY Ȃǂ Row groups ^Onh`邽߂̊NXłB
 * </P>
 * <P>
 * THEAD ATFOOT ATBODY  HTML 4 `͎̂ƂłB
 * <PRE>
 * &lt;!ENTITY % cellhalign
 *   "align      (left|center|right|justify|char) #IMPLIED
 *    char       %Character;    #IMPLIED  -- alignment char, e.g. char=':' --
 *    charoff    %Length;       #IMPLIED  -- offset for alignment char --"
 *   &gt;
 * 
 * &lt;!-- vertical alignment attributes for cell contents --&gt;
 * &lt;!ENTITY % cellvalign
 *   "valign     (top|middle|bottom|baseline) #IMPLIED"
 *   &gt;
 * 
 * &lt;!ELEMENT THEAD    - O (TR)+           -- table header --&gt;
 * &lt;!ELEMENT TFOOT    - O (TR)+           -- table footer --&gt;
 * 
 * &lt;!ELEMENT TBODY    O O (TR)+           -- table body --&gt;
 * 
 * &lt;!ATTLIST (THEAD|TBODY|TFOOT)          -- table section --
 *   %attrs;                              -- %coreattrs, %i18n, %events --
 *   %cellhalign;                         -- horizontal alignment in cells --
 *   %cellvalign;                         -- vertical alignment in cells --
 *   &gt;
 * </PRE>
 * </P>
 * @author Kenichi Fukuda
 */
public abstract class RowGroupsTag
	extends AttrsSupportTag
{
	private String elementName = null;

	/**
	 * <P>
	 * RowGroupsTag 쐬܂B
	 * </P>
	 * @param elementName vfBthead Atfoot ܂ tbody
	 */
	public RowGroupsTag(String elementName)
	{
		super();
		this.elementName = elementName;
	}

	/**
	 * <P>
	 * align Ԃ܂B
	 * </P>
	 * @return align 
	 */
	public String getAlign()
	{
		return getAttributeMap().getString("align");
	}

	/**
	 * <P>
	 * align ݒ肵܂B
	 * </P>
	 * @param align align 
	 */
	public void setAlign(String align)
	{
		getAttributeMap().putString("align", align);
	}

	/**
	 * <P>
	 * bgcolor Ԃ܂B
	 * </P>
	 * @return bgcolor 
	 */
	public String getBgcolor()
	{
		return getAttributeMap().getString("bgcolor");
	}

	/**
	 * <P>
	 * bgcolor ݒ肵܂B
	 * </P>
	 * @param bgcolor bgcolor 
	 */
	public void setBgcolor(String bgcolor)
	{
		getAttributeMap().putString("bgcolor", bgcolor);
	}

	/**
	 * <P>
	 * char Ԃ܂B
	 * </P>
	 * @return char 
	 */
	public String getChar()
	{
		return getAttributeMap().getString("char");
	}

	/**
	 * <P>
	 * char ݒ肵܂B
	 * </P>
	 * @param character char 
	 */
	public void setChar(String character)
	{
		getAttributeMap().putString("char", character);
	}

	/**
	 * <P>
	 * charoff Ԃ܂B
	 * </P>
	 * @return charoff 
	 */
	public String getCharoff()
	{
		return getAttributeMap().getString("charoff");
	}

	/**
	 * <P>
	 * charoff ݒ肵܂B
	 * </P>
	 * @param charoff charoff 
	 */
	public void setCharoff(String charoff)
	{
		getAttributeMap().putString("charoff", charoff);
	}

	/**
	 * <P>
	 * valign Ԃ܂B
	 * </P>
	 * @return valign 
	 */
	public String getValign()
	{
		return getAttributeMap().getString("valign");
	}

	/**
	 * <P>
	 * valign ݒ肵܂B
	 * </P>
	 * @param valign valign 
	 */
	public void setValign(String valign)
	{
		getAttributeMap().putString("valign", valign);
	}

	/**
	 * <P>
	 * I^ȌłB
	 * </P>
	 * @return EVAL_PAGE
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("</").append(this.elementName).append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doEndTag();
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();
		buf.append("<").append(this.elementName);

		String keys[] = new String[this.getAttributeMap().size()];
		keys = (String[])this.getAttributeMap().keySet().toArray(keys);
		for (int i = 0; i < keys.length; i++)
		{
			buf.append(" ").append(keys[i]).append("=\"");
			buf.append(this.getAttributeMap().getString(keys[i]));
			buf.append("\"");
		}

		buf.append(">");

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
