/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import jp.morpho.webapp.servlet.jsp.tagext.ListTag;


/**
 * <P>
 * HTML  TBODY ^OnhłB
 * </P>
 * @author Kenichi Fukuda
 */
public abstract class TBodyTag
	extends RowGroupsTag
	implements ListTag
{
	/** XR[vŎw肳ꂽIuWFNg̖̑ */
	private String name = null;

	/** XR[v */
	private String scope = null;

	/** e[u쐬郊Xg */
	private List bodyList = null;

	/** e[u쐬郊Xg̗vf̈ʒu */
	private int listIndex = 0;

	/**
	 * <P>
	 * TBodyTag 쐬܂B
	 * </P>
	 */
	public TBodyTag()
	{
		super("tbody");
	}

	/**
	 * <P>
	 * name Ԃ܂B
	 * </P>
	 * @return name 
	 */
	public String getName()
	{
		return (name != null) ? name : "";
	}

	/**
	 * <P>
	 * name ݒ肵܂B
	 * </P>
	 * @param name name 
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * <P>
	 * scope Ԃ܂B
	 * </P>
	 * @return scope 
	 */
	public String getScope()
	{
		return (scope != null) ? scope : "";
	}

	/**
	 * <P>
	 * scope ݒ肵܂B
	 * </P>
	 * @param scope scope 
	 */
	public void setScope(String scope)
	{
		this.scope = scope;
	}

	/**
	 * <P>
	 * ݍs̗̒l֘At}bvԂ܂B
	 * </P>
	 * @return ݍs̗̒l֘At}bv
	 */
	public Map getRowMap()
	{
		return (Map)bodyList.get(listIndex);
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		listIndex = 0;
		super.doStartTag();

		int scope = PageContext.PAGE_SCOPE;
		if ("request".equals(this.getScope()))
		{
			scope = PageContext.REQUEST_SCOPE;
		}
		else if ("session".equals(this.getScope()))
		{
			scope = PageContext.SESSION_SCOPE;
		}
		else if ("application".equals(this.getScope()))
		{
			scope = PageContext.APPLICATION_SCOPE;
		}
		bodyList = (List)pageContext.getAttribute(this.getName(), scope);

		if (bodyList == null || bodyList.size() == 0)
		{
			return SKIP_BODY;
		}
		else
		{
			return EVAL_BODY_BUFFERED;
		}
	}

	/**
	 * <P>
	 * Xg̗vf̐^O{̂]܂B
	 * </P>
	 * @return SKIP_BODY
	 * @see javax.servlet.jsp.tagext.IterationTag#doAfterBody()
	 */
	public int doAfterBody() throws JspException
	{
		super.doAfterBody();
		listIndex++;
		if (listIndex < bodyList.size())
		{
			return EVAL_BODY_AGAIN;
		}
		else
		{
			return SKIP_BODY;
		}
	}

}
