/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.resource;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.FrameworkException;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionRequestFactory;
import jp.morpho.webapp.servlet.http.HttpSessionAttributeNames;
import jp.morpho.webapp.servlet.jsp.tagext.BaseTag;

/**
 * <P>
 * w肳ꂽL[̃\[X擾܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class ResourceTag
	extends BaseTag
{

	/**
	 * <P>
	 * ResourceTag 쐬܂B
	 * </P>
	 */
	public ResourceTag()
	{
		super();
	}

	/**
	 * <P>
	 * key Ԃ܂B
	 * </P>
	 * @return key 
	 */
	public String getKey()
	{
		return getAttributeMap().getString("key");
	}

	/**
	 * <P>
	 * key ݒ肵܂B
	 * </P>
	 * @param key key 
	 */
	public void setKey(String key)
	{
		getAttributeMap().putString("key", key);
	}

	/**
	 * <P>
	 * arguments Ԃ܂B
	 * </P>
	 * @return arguments 
	 */
	public Object[] getArguments()
	{
		return (Object[])getAttributeMap().getObject("arguments");
	}

	/**
	 * <P>
	 * arguments ݒ肵܂B
	 * </P>
	 * @param arguments arguments 
	 */
	public void setArguments(Object[] arguments)
	{
		getAttributeMap().putObject("arguments", arguments);
	}

	/**
	 * <P>
	 * locale Ԃ܂B
	 * </P>
	 * @return locale 
	 */
	public Locale getLocale()
	{
		return (Locale)getAttributeMap().getObject("locale");
	}

	/**
	 * <P>
	 * locale ݒ肵܂B
	 * </P>
	 * @param locale locale 
	 */
	public void setLocale(Locale locale)
	{
		getAttributeMap().putObject("locale", locale);
	}

	/**
	 * <P>
	 * \[Xoh܂B
	 * \[X̎ނɂẮA@ύXꍇ܂B
	 * ̂悤ȃ\[Xׂ͂āAResourceTag NX̃TuNXɂĎł܂B
	 * </P>
	 * @param mrm bZ[W \[X }l[W
	 * @param locale \[XohKvȃP[
	 * @return \[X
	 */
	protected String getResource(MessageResourceManager mrm, Locale locale)
	{
		return mrm.getMessage(getKey(), getArguments(), locale);
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		StringBuffer buf = new StringBuffer();

		HttpActionRequest request =
			HttpActionRequestFactory.getInstance().getRequest(
				(HttpServletRequest)pageContext.getRequest());
		try
		{
			FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
			MessageResourceManager mrm = (MessageResourceManager)fc.get(PluginKeys.messageResourceManager);

			Locale locale = getLocale();
			if (locale == null)
			{
				locale = (Locale)request.getSession().getAttribute(HttpSessionAttributeNames.locale);
			}
			if (locale == null)
			{
				locale = request.getLocale();
			}

			String message = getResource(mrm, locale);

			buf.append(message);
		}
		catch (FrameworkException e1)
		{
		}

		try
		{
			JspWriter out = pageContext.getOut();
			out.print(buf.toString());
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}

		return super.doStartTag();
	}

}
