/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.io.InputStream;
import java.io.Serializable;

import javax.servlet.ServletContext;

/**
 * <P>
 * of[^ t@Ng̋@\`܂B
 * of[^ t@NǵAof[^ IuWFNg XML `t@C琶邽߂Ɏgp܂B
 * </P>
 * @author Kenichi Fukuda
 */
public abstract class ValidatorFactory
	implements Serializable
{

	/**
	 * <P>
	 * ValidatorFactory 쐬܂B
	 * </P>
	 */
	protected ValidatorFactory()
	{
		super();
	}

	/**
	 * <P>
	 * of[^ t@Ng IuWFNg쐬܂B
	 * </P>
	 * @return of[^ t@Ng IuWFNg
	 * @exception ValidatorException of[^ t@Ng IuWFNg쐬łȂꍇ
	 */
	public static synchronized ValidatorFactory getInstance() throws ValidatorException
	{
		try
		{
			ValidatorFactory vf = new ValidatorFactoryImpl();

			return vf;
		}
		catch (Exception e)
		{
			throw new ValidatorException(e);
		}
	}

	/**
	 * <P>
	 * of[^ IuWFNg𐶐ANX[_ XML `t@Cǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * </P>
	 * @param name NX[_ XML `t@C̖O
	 * @return NX[_ XML `t@C̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public abstract Validator generateValidator(String name) throws ValidatorException;

	/**
	 * <P>
	 * of[^ IuWFNg𐶐A̓Xg[ǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * </P>
	 * @param in of[^ f[^̓Xg[
	 * @return ̓Xg[̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public abstract Validator generateValidator(InputStream in) throws ValidatorException;

	/**
	 * <P>
	 * of[^ IuWFNg𐶐Aw肳ꂽpXɂ XML `t@Cǂݏoꂽf[^gāÃof[^ IuWFNg܂B
	 * ̃\bh́ANX[_ɊÂă\[X generateValidator(String) Ƃ͈قȂprɎg܂B
	 * ̃\bhł́ANX[_gp܂B
	 * \[X̌ɂ ServletContext IuWFNggp܂B
	 * </P>
	 * @param path \[Xւ̃pXw肷 String
	 * @return w肳ꂽpXɂ XML `t@C̃f[^gďꂽof[^ IuWFNg
	 * @exception ValidatorException \̓G[̏ꍇ
	 */
	public abstract Validator generateValidator(ServletContext sc, String path) throws ValidatorException;
}
