/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import jp.morpho.util.ConversionList;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * <P>
 * w肳ꂽLƂȂꍇɌ؏s Validator V[PXłB
 * 肪oĂȂtB[h date1  date2 w肵ꍇÃtB[hɖ肪oĂȂꍇɌA؏s܂B
 * Ⴆ΁AtH[ɓt2͂A2Ƃ͂Ăꍇɓt̑召`FbNsAԃ`FbNs肷ꍇɗLłB
 * </P>
 * @author Kenichi Fukuda
 */
public class ValidatorIf
	extends ValidatorSequence
{
	/** 肪oĂȂtB[h̖ÕXg */
	private ConversionList validFieldList = new ConversionList();

	/** 肪oĂtB[h̖ÕXg */
	private ConversionList invalidFieldList = new ConversionList();

	/** LĂtB[h̖ÕXg */
	private ConversionList enteredFieldList = new ConversionList();

	/** LĂȂtB[h̖ÕXg */
	private ConversionList emptyFieldList = new ConversionList();

	/**
	 * <P>
	 * 肪oĂȂׂẴtB[h̖O폜܂B
	 * </P>
	 */
	public void removeAllValidFieldNames()
	{
		validFieldList.clear();
	}

	/**
	 * <P>
	 * 肪oĂȂtB[h̖Oǉ܂B
	 * </P>
	 * @param name 肪oĂȂtB[h̖O
	 */
	public void addValidFieldName(String name)
	{
		validFieldList.addString(name);
	}

	/**
	 * <P>
	 * 肪oĂȂׂẴtB[h̖OK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return 肪oĂȂׂẴtB[h̖OK؂ȏŊi[Ăz
	 */
	public String[] getValidFieldNames()
	{
		String[] names = new String[validFieldList.size()];
		return (String[])validFieldList.toArray(names);
	}

	/**
	 * <P>
	 * 肪oĂ邷ׂẴtB[h̖O폜܂B
	 * </P>
	 */
	public void removeAllInvalidFieldNames()
	{
		invalidFieldList.clear();
	}

	/**
	 * <P>
	 * 肪oĂtB[h̖Oǉ܂B
	 * </P>
	 * @param name 肪oĂtB[h̖O
	 */
	public void addInvalidFieldName(String name)
	{
		invalidFieldList.addString(name);
	}

	/**
	 * <P>
	 * 肪oĂ邷ׂẴtB[h̖OK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return 肪oĂ邷ׂẴtB[h̖OK؂ȏŊi[Ăz
	 */
	public String[] getInvalidFieldNames()
	{
		String[] names = new String[invalidFieldList.size()];
		return (String[])invalidFieldList.toArray(names);
	}

	/**
	 * <P>
	 * LĂ邷ׂẴtB[h̖O폜܂B
	 * </P>
	 */
	public void removeAllEnteredFieldNames()
	{
		enteredFieldList.clear();
	}

	/**
	 * <P>
	 * LĂtB[h̖Oǉ܂B
	 * </P>
	 * @param name LĂtB[h̖O
	 */
	public void addEnteredFieldName(String name)
	{
		enteredFieldList.addString(name);
	}

	/**
	 * <P>
	 * LĂ邷ׂẴtB[h̖OK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return LĂ邷ׂẴtB[h̖OK؂ȏŊi[Ăz
	 */
	public String[] getEnteredFieldNames()
	{
		String[] names = new String[enteredFieldList.size()];
		return (String[])enteredFieldList.toArray(names);
	}

	/**
	 * <P>
	 * LĂȂׂẴtB[h̖O폜܂B
	 * </P>
	 */
	public void removeAllEmptyFieldNames()
	{
		emptyFieldList.clear();
	}

	/**
	 * <P>
	 * LĂȂtB[h̖Oǉ܂B
	 * </P>
	 * @param name LĂȂtB[h̖O
	 */
	public void addEmptyFieldName(String name)
	{
		emptyFieldList.addString(name);
	}

	/**
	 * <P>
	 * LĂȂׂẴtB[h̖OK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return LĂȂׂẴtB[h̖OK؂ȏŊi[Ăz
	 */
	public String[] getEmptyFieldNames()
	{
		String[] names = new String[emptyFieldList.size()];
		return (String[])emptyFieldList.toArray(names);
	}

	/**
	 * <P>
	 * w肳ꂽLƂȂꍇ super.validate(request) Ăяo܂B
	 * </P>
	 * @param request vIuWFNg
	 * @throws ValidationException Ó؂Ƃɖ肪oꂽꍇ
	 */
	public void validate(HttpActionRequest request) throws ValidationException
	{
		ValidationState vs = ValidationState.getInstance(request);
		for (int i = 0; i < validFieldList.size(); i++)
		{
			if (vs.isInvalidField(validFieldList.getString(i)))
			{
				return;
			}
		}
		for (int i = 0; i < invalidFieldList.size(); i++)
		{
			if (!vs.isInvalidField(invalidFieldList.getString(i)))
			{
				return;
			}
		}

		super.validate(request);
	}

}
