/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.fill.DatasetSortUtil;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.SortInfo;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

class SortFillDatasetRun
extends JRFillDatasetRun {
    private JRSortField[] allSortFields;
    private SortInfo sortInfo;
    private List records;

    public SortFillDatasetRun(JRBaseFiller filler, JRFillDataset dataset, SortInfo sortInfo) throws JRException {
        super(filler, (JRDatasetRun)new JRDesignDatasetRun(), dataset);
        this.allSortFields = DatasetSortUtil.getAllSortFields(dataset);
        this.sortInfo = sortInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List sort() throws JRException {
        this.records = new ArrayList();
        try {
            this.iterate();
        }
        finally {
            this.dataset.closeDatasource();
        }
        return this.records;
    }

    protected void detail() throws JRScriptletException, JRException {
        int i;
        super.detail();
        JRField[] fields = this.dataset.getFields();
        Object[] record = new Object[this.sortInfo.fieldNames.size()];
        for (i = 0; i < fields.length; ++i) {
            record[i] = this.dataset.getFieldValue(fields[i].getName());
        }
        for (i = 0; i < this.allSortFields.length; ++i) {
            JRSortField sortField = this.allSortFields[i];
            if (sortField.getType() != SortFieldTypeEnum.VARIABLE) continue;
            record[fields.length + i] = this.dataset.getVariableValue(sortField.getName());
        }
        this.records.add(record);
    }
}

