/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.ResourceManager;
import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiMainWindow;
import com.wiki.standalone.moxkiriya.dialog.ConfigSettingsDialog;
import com.wiki.standalone.moxkiriya.dialog.DialogBase;
import com.wiki.standalone.moxkiriya.dialog.SelectPartyDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Main
extends Application {
    private Stage primaryStage_ = null;
    private SettingManager settingManager_ = null;
    private ResourceBundle resources_;
    public static ResourceManager resourceManagr_ = new ResourceManager();
    private WikiMainWindow wikiMainWindow_;

    public static void main(String[] args) {
        Main.launch(args);
    }

    @Override
    public void start(Stage primaryStage) {
        this.primaryStage_ = primaryStage;
        this.settingManager_ = SettingManager.getInstance();
        this.resources_ = ResourceBundle.getBundle("com.wiki.standalone.moxkiriya.resources.moxkiriya");
        try {
            try {
                WikiMainWindow.CloseType closeType = WikiMainWindow.CloseType.EXIT;
                do {
                    String AppRoot = null;
                    String wikiroot = null;
                    String selectedParty = this.loadSelectedParty();
                    if (selectedParty != null) {
                        AppRoot = this.settingManager_.get("moxkiriyaroot");
                        wikiroot = this.settingManager_.get("wikiroot");
                    }
                    if (AppRoot == null || wikiroot == null) {
                        Stage stage = new Stage(StageStyle.UNDECORATED);
                        stage.initOwner(primaryStage);
                        this.showConfigSettingsDialog(stage, selectedParty);
                    }
                    if ((closeType = this.showWikiMainWindow()) != WikiMainWindow.CloseType.RESTART) continue;
                    this.wikiMainWindow_.closeSession();
                } while (closeType != WikiMainWindow.CloseType.EXIT);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.wikiMainWindow_ != null) {
                    this.wikiMainWindow_.closeSession();
                }
                this.primaryStage_.hide();
            }
        }
        finally {
            if (this.wikiMainWindow_ != null) {
                this.wikiMainWindow_.closeSession();
            }
            this.primaryStage_.hide();
        }
    }

    private WikiMainWindow.CloseType showWikiMainWindow() throws Exception {
        File wikirootPath;
        WikiMainWindow.CloseType closeType = WikiMainWindow.CloseType.EXIT;
        String appRoot = this.settingManager_.get("moxkiriyaroot");
        if (appRoot != null && (wikirootPath = new File(String.valueOf(appRoot) + "/" + "wikiroot")) != null) {
            wikirootPath.mkdirs();
            this.wikiMainWindow_ = new WikiMainWindow(this.primaryStage_, this.resources_);
            this.wikiMainWindow_.buildWikiMainTree(wikirootPath);
            this.wikiMainWindow_.uploadResourcefile(String.valueOf(appRoot) + "/icon/Icon_External_Link.png", "icon/Icon_External_Link.png");
            closeType = this.wikiMainWindow_.show();
        }
        return closeType;
    }

    private String loadSelectedParty() throws Exception {
        ArrayList<String> partyList;
        String selectedParty = this.settingManager_.getSelectedParty();
        if (selectedParty != null && selectedParty.isEmpty() && !(partyList = this.settingManager_.getPartyList()).isEmpty()) {
            SelectPartyDialog dialog = new SelectPartyDialog();
            if (dialog.showDialog(this.primaryStage_, this.resources_) == DialogBase.CloseType.OK) {
                String path = this.settingManager_.get("MOXKIRIYA_USER_DIR");
                this.settingManager_.savePartyConfig(path);
                selectedParty = this.settingManager_.getSelectedParty();
            } else {
                selectedParty = "";
            }
        }
        return selectedParty;
    }

    private void showConfigSettingsDialog(Stage stage, String selectedParty) throws Exception {
        ConfigSettingsDialog dialog = new ConfigSettingsDialog(selectedParty);
        dialog.showDialog(stage, this.resources_);
        Hashtable<String, String> settingsTable = dialog.getSettingsTable();
        String path = this.settingManager_.get("MOXKIRIYA_USER_DIR");
        if (selectedParty == null || selectedParty.isEmpty()) {
            selectedParty = dialog.getPartyName();
        }
        if (!selectedParty.isEmpty()) {
            this.settingManager_.putParty(selectedParty, dialog.getDefaultPartyCheckValue());
            this.settingManager_.savePartyConfig(path);
            this.settingManager_.saveSettingConfig(path, selectedParty, settingsTable);
            this.settingManager_.loadSettingFiles(path);
        }
    }
}

