/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.util.FileIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;

public class PageData {
    private Node node_ = null;
    private Version baseVersion_ = null;
    private SimpleStringProperty namespace_ = new SimpleStringProperty("");
    private SimpleStringProperty title_ = new SimpleStringProperty("");
    private SimpleStringProperty content_ = new SimpleStringProperty("");
    private SimpleStringProperty date_ = new SimpleStringProperty("");
    private SimpleBooleanProperty check_ = new SimpleBooleanProperty(false);
    private ArrayList<String> categories_ = new ArrayList();
    private FileData fileData_ = null;

    public PageData() {
    }

    public PageData(Node node) throws Exception {
        this.setNode(node);
    }

    public Node getNode() {
        return this.node_;
    }

    public void setNode(Node node) throws Exception {
        try {
            Value[] categories;
            this.node_ = node;
            this.namespace_.setValue(node.getProperty("moxki:namespace").getString());
            this.title_.setValue(node.getProperty("moxki:title").getString());
            this.content_.setValue(node.getProperty("moxki:content").getString());
            Value[] valueArray = categories = node.getProperty("moxki:category").getValues();
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                Value category = valueArray[n2];
                this.addCategory(category.getString());
                ++n2;
            }
            Node fileNode = node.getNode("moxki:file");
            if (fileNode != null) {
                this.fileData_ = new FileData(fileNode);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public StringProperty uuidProperty() {
        SimpleStringProperty property = new SimpleStringProperty();
        try {
            property.setValue(this.node_.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return property;
    }

    public BooleanProperty checkProperty() {
        return this.check_;
    }

    public String getNamespace() {
        return this.namespace_.getValue();
    }

    public void setNamespace(String namespace) {
        this.namespace_.setValue(namespace);
    }

    public String getTitle() {
        return this.title_.getValue();
    }

    public void setTitle(String title) {
        this.title_.setValue(title);
    }

    public StringProperty titleProperty() {
        return this.title_;
    }

    public String getContent() {
        return this.content_.getValue();
    }

    public void setContent(String content) {
        this.content_.setValue(content);
        this.categories_ = this.extractCategoriesFromContent(content);
    }

    public String getIntroduction() throws Exception {
        String line;
        BufferedReader buffreader = FileIO.bufferedReader(new StringReader(this.content_.getValue()));
        StringBuffer buf = new StringBuffer("");
        int lineCount = 0;
        int charCount = 0;
        Pattern hnPattern = Pattern.compile("^={2,6}[^=]+={2,6}$");
        while ((line = buffreader.readLine()) != null) {
            if (hnPattern.matcher(line).matches()) break;
            if (charCount + line.length() > 255) {
                buf.append(line.substring(0, 255 - charCount));
                charCount = 255;
                break;
            }
            buf.append(String.valueOf(line) + "\n");
            charCount += line.length() + 1;
            if (++lineCount >= 3) break;
        }
        String intro = buf.toString();
        return intro.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public StringProperty introductionProperty() {
        String introduction = "";
        try {
            introduction = this.getIntroduction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SimpleStringProperty(introduction);
    }

    public StringProperty dateProperty() {
        String date = "";
        try {
            date = this.baseVersion_.getCreated().getTime().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SimpleStringProperty(date);
    }

    public void setBaseVersion(Version baseVersion) {
        this.baseVersion_ = baseVersion;
    }

    public ArrayList<String> getCategories() {
        return this.categories_;
    }

    public void addCategory(String category) {
        this.categories_.add(category);
    }

    public FileData getFileData() {
        return this.fileData_;
    }

    public void setFileData(File file) throws Exception {
        this.fileData_ = new FileData(file);
    }

    private ArrayList<String> extractCategoriesFromContent(String content) {
        ArrayList<String> categories = new ArrayList<String>();
        char[] charArrayContent = content.toCharArray();
        int count = 0;
        block0: while (count < charArrayContent.length) {
            if (charArrayContent[count] == '<') {
                String sub = content.substring(count);
                if (content.startsWith("<code>")) {
                    count += this.extractCategoriesSkipElem(sub, "<code>", "</code>");
                    continue;
                }
                if (sub.startsWith("<pre>")) {
                    count += this.extractCategoriesSkipElem(sub, "<pre>", "</pre>");
                    continue;
                }
                ++count;
                continue;
            }
            if (charArrayContent[count] == '[') {
                if (content.startsWith("[[Category:", count)) {
                    int startCount = count += "[[Category:".length();
                    while (count < charArrayContent.length) {
                        if (charArrayContent[++count] != ']' || !content.startsWith("]]", count)) continue;
                        int endCount = count;
                        String category = content.substring(startCount, endCount);
                        categories.add(category);
                        count += "]]".length();
                        continue block0;
                    }
                    continue;
                }
                ++count;
                continue;
            }
            ++count;
        }
        return categories;
    }

    private int extractCategoriesSkipElem(String content, String startElem, String endElem) {
        char[] charArrayContent = content.toCharArray();
        int count = 0;
        while (count < content.length()) {
            if (charArrayContent[++count] != '<') continue;
            String sub = content.substring(count);
            if (sub.startsWith(endElem)) {
                count += endElem.length();
                break;
            }
            if (!sub.startsWith(startElem)) continue;
            count += this.extractCategoriesSkipElem(sub, startElem, endElem);
        }
        return count;
    }

    public class FileData {
        private Node node_ = null;
        private String mimeType_;
        private InputStream inputStream_;
        private Calendar lastModified_;
        private String encoding_;

        public FileData(File file) throws Exception {
            this.setInputStream(file);
        }

        public FileData(Node node) throws Exception {
            this.setNode(node);
        }

        public Node getNode() {
            return this.node_;
        }

        public void setNode(Node node) throws Exception {
            this.node_ = node;
            this.setInputStream(node);
        }

        public InputStream getInputStream() {
            return this.inputStream_;
        }

        public void setInputStream(File file) throws Exception {
            this.inputStream_ = new FileInputStream(file);
            this.mimeType_ = URLConnection.guessContentTypeFromName(file.getAbsolutePath());
            this.lastModified_ = Calendar.getInstance();
            this.lastModified_.setTimeInMillis(file.lastModified());
            if (this.mimeType_.startsWith("text/")) {
                this.encoding_ = "UTF-8";
            }
        }

        public void setInputStream(Node node) throws Exception {
            Node nodeResource = node.getNode("{http://www.jcp.org/jcr/1.0}content");
            this.inputStream_ = nodeResource.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream();
            this.mimeType_ = nodeResource.getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString();
            this.lastModified_ = nodeResource.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate();
            if (this.mimeType_.startsWith("text/")) {
                this.encoding_ = nodeResource.getProperty("{http://www.jcp.org/jcr/1.0}encoding").getString();
            }
        }

        public String getMimeType() {
            return this.mimeType_;
        }

        public Calendar getLastModified() {
            return this.lastModified_;
        }
    }
}

