/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.WikiHelpWindowController;
import com.wiki.standalone.moxkiriya.WikiMainWindowController;
import com.wiki.standalone.moxkiriya.WikiRepository;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class WikiHelpWindow {
    private Stage motherStage_ = null;
    private ResourceBundle resources_ = null;
    private Stage stage_;
    private WikiHelpWindowController controller_;
    private WikiMainWindowController mainController_;
    private HelpWindowStatus helpWindowStatus_ = HelpWindowStatus.HIDE;

    public WikiHelpWindow(Stage motherStage, ResourceBundle resources) {
        this.motherStage_ = motherStage;
        this.resources_ = resources;
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("WikiHelpWindow.fxml"), this.resources_);
            loader.load();
            Scene scene = new Scene((Parent)loader.getRoot());
            scene.getStylesheets().add(this.getClass().getResource("application.css").toExternalForm());
            this.controller_ = (WikiHelpWindowController)loader.getController();
            this.controller_.setWikiHelpWindow(this);
            this.stage_ = new Stage(StageStyle.DECORATED);
            this.stage_.initOwner(this.motherStage_);
            this.stage_.setScene(scene);
            this.stage_.setTitle(this.resources_.getString("key.HelpWindow.Title"));
            this.stage_.setResizable(true);
            this.stage_.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    WikiHelpWindow.this.helpWindowStatus_ = newValue == false ? HelpWindowStatus.HIDE : HelpWindowStatus.SHOW;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMainWindowController(WikiMainWindowController mainController) {
        this.mainController_ = mainController;
    }

    public void setWikiRepository(WikiRepository wikiRepository) {
        this.controller_.setWikiRepository(wikiRepository);
    }

    public PageData getLatestContents() throws Exception {
        return this.mainController_.getLatestContents();
    }

    public void show() throws Exception {
        this.controller_.loadTableOfContent();
        if (this.helpWindowStatus_ == HelpWindowStatus.HIDE) {
            this.stage_.show();
        }
    }

    public void hide() {
        this.stage_.hide();
    }

    private static enum HelpWindowStatus {
        SHOW,
        HIDE;

    }
}

