/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.WikiHelpWindow;
import com.wiki.standalone.moxkiriya.WikiMainWindow;
import com.wiki.standalone.moxkiriya.WikiPreviewWindow;
import com.wiki.standalone.moxkiriya.dialog.AboutMoxkiriyaDialog;
import com.wiki.standalone.moxkiriya.dialog.AlertDialog;
import com.wiki.standalone.moxkiriya.dialog.DialogBase;
import com.wiki.standalone.moxkiriya.dialog.SelectPartyDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javax.jcr.NodeIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public class WikiMainWindowController
implements Initializable {
    private Stage stage_;
    private ResourceBundle resourceBundle_;
    private WikiEngine wikiEngine_;
    private WikiPreviewWindow previewWindow_ = null;
    private WikiHelpWindow helpWindow_ = null;
    @FXML
    private MenuItem menuItemNew;
    @FXML
    private MenuItem menuItemImport;
    @FXML
    private MenuItem menuItemExport;
    @FXML
    private MenuItem menuItemExit;
    @FXML
    private MenuItem menuItemSelectParty;
    @FXML
    private MenuItem menuItemAboutMoxkiriya;
    @FXML
    private ImageView imageViewLogo;
    @FXML
    private Hyperlink choiceViewHyperlinkReading;
    @FXML
    private Hyperlink choiceViewHyperlinkPageList;
    @FXML
    private Hyperlink choiceViewHyperlinkEdit;
    @FXML
    private ImageView ImageViewLoading;
    @FXML
    private AnchorPane AnchorPaneWebView;
    @FXML
    private Button webViewMenuAnchorPaneButtonBack;
    @FXML
    private Button webViewMenuAnchorPaneButtonForward;
    @FXML
    private Button webViewMenuAnchorPaneButtonReload;
    @FXML
    private Button webViewMenuAnchorPaneButtonHome;
    @FXML
    private TextField webViewMenuAnchorPaneTextFieldSearchWiki;
    @FXML
    private Button webViewMenuAnchorPaneButtonSearch;
    @FXML
    private Hyperlink sidemenuHyperlinkHelp;
    @FXML
    private Hyperlink sidemenuHyperlinkCategories;
    @FXML
    private Hyperlink webViewHyperlinkMain;
    @FXML
    private Hyperlink webViewHyperlinkHistory;
    @FXML
    private AnchorPane webViewAnchorPaneMain;
    @FXML
    private WebView webView;
    @FXML
    private AnchorPane webViewAnchorPaneHistory;
    @FXML
    private FlowPane webViewHistoryBreadcrumbsPane;
    @FXML
    private ListView<VersionHistoryListItem> webViewHistoryListView;
    @FXML
    private AnchorPane webViewHistoryAnchorPaneContent;
    @FXML
    private TextField webViewHistoryTextFieldTitle;
    @FXML
    private TextArea webViewHistorytextAreaContents;
    @FXML
    private Button webViewHistoryButtonRestoreVersion;
    @FXML
    private AnchorPane AnchorPaneEdit;
    @FXML
    private TextField textFieldTitle;
    @FXML
    private TextArea textAreaContents;
    @FXML
    private Label labelAttacheFile;
    @FXML
    private TextField textFieldAttachFile;
    @FXML
    private Button buttonChoiceFile;
    @FXML
    private Hyperlink hyperlinkEditAttachFiles;
    @FXML
    private Button buttonPreview;
    @FXML
    private Button buttonSave;
    @FXML
    private Button buttonCancel;
    @FXML
    private AnchorPane AnchorPaneContentList;
    @FXML
    private ComboBox<String> comboBoxNamespace;
    @FXML
    private Hyperlink hyperlinkRedraw;
    @FXML
    private TableView<PageData> tableViewContentList;
    @FXML
    private TableColumn<PageData, Boolean> tableColumnCheck;
    @FXML
    private TableColumn<PageData, String> tableColumnTitle;
    @FXML
    private TableColumn<PageData, String> tableColumnContent;
    @FXML
    private TableColumn<PageData, String> tableColumnDate;
    @FXML
    private TableColumn<PageData, String> tableColumnRefs;
    @FXML
    private Button buttonDeletePages;
    private CheckBox checkBoxAll_;
    private EditMode editMode_ = EditMode.NONE;
    private WikiMainWindow.CloseType closeType_ = WikiMainWindow.CloseType.EXIT;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle_ = resourceBundle;
        this.setLinkClickListner(this.webView.getEngine());
        this.webView.setContextMenuEnabled(false);
        this.previewWindow_ = new WikiPreviewWindow(this.stage_, this.resourceBundle_);
        this.previewWindow_.setMainWindowController(this);
        this.helpWindow_ = new WikiHelpWindow(this.stage_, this.resourceBundle_);
        this.helpWindow_.setMainWindowController(this);
        SettingManager settingMgr = SettingManager.getInstance();
        String moxkiriyaroot = settingMgr.get("moxkiriyaroot");
        File logoFile = new File(String.valueOf(moxkiriyaroot) + "/icon/" + "logo.png");
        if (logoFile.exists()) {
            try {
                this.imageViewLogo.setImage(new Image(new FileInputStream(logoFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.checkBoxAll_ = new CheckBox();
        this.checkBoxAll_.selectedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                ObservableList pageDataList = WikiMainWindowController.this.tableViewContentList.getItems();
                for (PageData pageData : pageDataList) {
                    pageData.checkProperty().setValue(newValue);
                }
            }
        });
        this.tableColumnCheck.setCellFactory(new Callback<TableColumn<PageData, Boolean>, TableCell<PageData, Boolean>>(){

            @Override
            public TableCell<PageData, Boolean> call(TableColumn<PageData, Boolean> param) {
                CheckBoxTableCell<PageData, Boolean> checkBoxTableCell = new CheckBoxTableCell<PageData, Boolean>();
                checkBoxTableCell.setAlignment(Pos.CENTER);
                return checkBoxTableCell;
            }
        });
        this.tableColumnTitle.setCellFactory(new Callback<TableColumn<PageData, String>, TableCell<PageData, String>>(){

            @Override
            public TableCell<PageData, String> call(TableColumn<PageData, String> param) {
                TableCell<PageData, String> tableCell = new TableCell<PageData, String>(){

                    @Override
                    public void updateItem(String uuid, boolean empty) {
                        super.updateItem(uuid, empty);
                        if (!empty) {
                            try {
                                HashMap<String, PageData> pageMap = WikiMainWindowController.this.wikiEngine_.queryPageUUID(uuid);
                                PageData pageData = pageMap.get(uuid);
                                Hyperlink hyperlink = new Hyperlink(pageData.getTitle());
                                hyperlink.setUserData(pageData);
                                hyperlink.setOnMouseClicked((EventHandler<? super MouseEvent>)new EventHandler<Event>(){

                                    @Override
                                    public void handle(Event event) {
                                        try {
                                            Hyperlink source = (Hyperlink)event.getSource();
                                            PageData pageData = (PageData)source.getUserData();
                                            WikiMainWindowController.this.wikiEngine_.setPageDataMap(pageData);
                                            WikiMainWindowController.this.loadWikiContent();
                                            WikiMainWindowController.this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
                                            WikiMainWindowController.this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
                                            WikiMainWindowController.this.webViewAnchorPaneMain.setVisible(true);
                                            WikiMainWindowController.this.webViewAnchorPaneHistory.setVisible(false);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                this.setGraphic(hyperlink);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return tableCell;
            }
        });
        this.webViewHistoryListView.setCellFactory(new Callback<ListView<VersionHistoryListItem>, ListCell<VersionHistoryListItem>>(){

            @Override
            public ListCell<VersionHistoryListItem> call(ListView<VersionHistoryListItem> arg0) {
                return new ListCell<VersionHistoryListItem>(){

                    @Override
                    protected void updateItem(VersionHistoryListItem item, boolean empty) {
                        try {
                            super.updateItem(item, empty);
                            if (!empty) {
                                Hyperlink hyperlinkCreated = new Hyperlink(item.getCreated().toString());
                                Version version = item.getVersion();
                                Version baseVersion = WikiMainWindowController.this.wikiEngine_.getBaseVersion();
                                if (version.getIdentifier().equals(baseVersion.getIdentifier())) {
                                    hyperlinkCreated.setId("webViewHistoryBaseVersion");
                                }
                                hyperlinkCreated.setUserData(item);
                                hyperlinkCreated.setOnAction(new EventHandler<ActionEvent>(){

                                    @Override
                                    public void handle(ActionEvent event) {
                                        try {
                                            ObservableList<Node> breadcrumbsList = WikiMainWindowController.this.webViewHistoryBreadcrumbsPane.getChildren();
                                            breadcrumbsList.clear();
                                            breadcrumbsList.add(WikiMainWindowController.this.createBreadcrumbsHyperlink("key.History.Breadcrumbs.List", new EventHandler<ActionEvent>(){

                                                @Override
                                                public void handle(ActionEvent event) {
                                                    ObservableList<Node> breadcrumbsList = WikiMainWindowController.this.webViewHistoryBreadcrumbsPane.getChildren();
                                                    breadcrumbsList.clear();
                                                    breadcrumbsList.add(WikiMainWindowController.this.createBreadcrumbsLabel("key.History.Breadcrumbs.List"));
                                                    WikiMainWindowController.this.webViewHistoryListView.setVisible(true);
                                                    WikiMainWindowController.this.webViewHistoryAnchorPaneContent.setVisible(false);
                                                }
                                            }));
                                            breadcrumbsList.add(WikiMainWindowController.this.createBreadcrumbsLabel("key.History.Breadcrumbs.Separator"));
                                            breadcrumbsList.add(WikiMainWindowController.this.createBreadcrumbsLabel("key.History.Breadcrumbs.Content"));
                                            Hyperlink target = (Hyperlink)event.getTarget();
                                            VersionHistoryListItem item = (VersionHistoryListItem)target.getUserData();
                                            javax.jcr.Node node = item.getNode();
                                            WikiMainWindowController.this.webViewHistoryTextFieldTitle.setText(node.getProperty("moxki:title").getString());
                                            WikiMainWindowController.this.webViewHistorytextAreaContents.setText(node.getProperty("moxki:content").getString());
                                            WikiMainWindowController.this.webViewHistoryAnchorPaneContent.setUserData(item);
                                            WikiMainWindowController.this.webViewHistoryListView.setVisible(false);
                                            WikiMainWindowController.this.webViewHistoryAnchorPaneContent.setVisible(true);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                this.setGraphic(hyperlinkCreated);
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                };
            }
        });
        this.tableColumnCheck.setGraphic(this.checkBoxAll_);
        this.tableColumnCheck.setCellValueFactory(new PropertyValueFactory("check"));
        this.tableColumnTitle.setCellValueFactory(new PropertyValueFactory("uuid"));
        this.tableColumnContent.setCellValueFactory(new PropertyValueFactory("introduction"));
        this.tableColumnDate.setCellValueFactory(new PropertyValueFactory("date"));
        this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
        this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
        this.webViewAnchorPaneMain.setVisible(true);
        this.webViewAnchorPaneHistory.setVisible(false);
    }

    public WikiMainWindow.CloseType getCloseType() {
        return this.closeType_;
    }

    public void setStage(Stage stage) {
        this.stage_ = stage;
    }

    public void setWikiEngine(WikiEngine wikiEngine) {
        this.wikiEngine_ = wikiEngine;
    }

    public WikiEngine getWikiEngine() {
        return this.wikiEngine_;
    }

    public void hidePreviewWindow() {
        this.previewWindow_.hide();
    }

    @FXML
    public void onActionMenuItemNew(ActionEvent event) {
        this.textFieldTitle.clear();
        this.textAreaContents.clear();
        this.buildEditView("");
    }

    @FXML
    public void onActionMenuItemImport(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle_.getString("key.ImportDialog.Title"));
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML Files", "*.xml")});
        File selectedFile = fileChooser.showOpenDialog(this.stage_);
        if (selectedFile != null) {
            try {
                this.wikiEngine_.importSystemView(selectedFile);
                AlertDialog dialog = new AlertDialog(AlertDialog.MessageType.SuccessImport);
                dialog.showDialog(this.stage_, this.resourceBundle_);
                this.stage_.hide();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    AlertDialog dialog = new AlertDialog(AlertDialog.MessageType.FailureImport);
                    dialog.showDialog(this.stage_, this.resourceBundle_);
                    this.stage_.hide();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    @FXML
    public void onActionMenuItemExport(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle_.getString("key.ExportDialog.Title"));
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML Files", "*.xml")});
        File selectedFile = fileChooser.showSaveDialog(this.stage_);
        if (selectedFile != null) {
            try {
                this.wikiEngine_.exportSystemView(selectedFile);
                AlertDialog dialog = new AlertDialog(AlertDialog.MessageType.SuccessExport);
                dialog.showDialog(this.stage_, this.resourceBundle_);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    AlertDialog dialog = new AlertDialog(AlertDialog.MessageType.FailureExport);
                    dialog.showDialog(this.stage_, this.resourceBundle_);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    @FXML
    public void onActionMenuItemExit(ActionEvent event) {
        try {
            if (this.AnchorPaneEdit.isVisible()) {
                if (this.showConfirmEditCancelDialog() == DialogBase.CloseType.OK) {
                    this.editMode_ = EditMode.NONE;
                    this.wikiEngine_.cancelCheckout();
                    this.previewWindow_.hide();
                    this.stage_.hide();
                }
            } else {
                this.stage_.hide();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionMenuItemSelectParty(ActionEvent event) {
        try {
            SelectPartyDialog selectPartyDialog;
            if (this.AnchorPaneEdit.isVisible() && this.showConfirmEditCancelDialog() == DialogBase.CloseType.OK) {
                this.editMode_ = EditMode.NONE;
                this.wikiEngine_.cancelCheckout();
            }
            if ((selectPartyDialog = new SelectPartyDialog()).showDialog(this.stage_, this.resourceBundle_) == DialogBase.CloseType.OK) {
                this.closeType_ = WikiMainWindow.CloseType.RESTART;
                this.stage_.hide();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionMenuItemAboutMoxkiriya(ActionEvent event) {
        try {
            AboutMoxkiriyaDialog dialog = new AboutMoxkiriyaDialog();
            dialog.showDialog(this.stage_, this.resourceBundle_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onKeyPressedTextFieldSearchWiki(KeyEvent event) {
        try {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.doSearchWiki();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonSearch(ActionEvent event) {
        try {
            this.doSearchWiki();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedHyperlinkReading() {
        try {
            DialogBase.CloseType closeType = DialogBase.CloseType.OK;
            if (this.AnchorPaneEdit.isVisible()) {
                closeType = this.showConfirmEditCancelDialog();
            }
            if (closeType == DialogBase.CloseType.OK) {
                this.editMode_ = EditMode.NONE;
                this.wikiEngine_.cancelCheckout();
                PageData pageData = this.getSelectingPageData();
                if (pageData != null) {
                    this.wikiEngine_.setPageDataMap(pageData);
                }
                this.menuItemNew.setDisable(false);
                this.loadWikiContent();
                this.AnchorPaneEdit.setVisible(false);
                this.AnchorPaneContentList.setVisible(false);
                this.AnchorPaneWebView.setVisible(true);
                this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
                this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
                this.webViewAnchorPaneMain.setVisible(true);
                this.webViewAnchorPaneHistory.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedHyperlinkEdit() {
        try {
            this.wikiEngine_.refreshSession();
            this.buildEditView(EditMode.MODIFY, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedHyperlinkPageList() {
        try {
            DialogBase.CloseType closeType = DialogBase.CloseType.OK;
            if (this.AnchorPaneEdit.isVisible()) {
                closeType = this.showConfirmEditCancelDialog();
            }
            if (closeType == DialogBase.CloseType.OK) {
                this.editMode_ = EditMode.NONE;
                this.wikiEngine_.cancelCheckout();
                this.buildComboBoxNamespace();
                this.buildTableViewPageList();
                this.AnchorPaneWebView.setVisible(false);
                this.AnchorPaneEdit.setVisible(false);
                this.AnchorPaneContentList.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonBack(ActionEvent event) {
        try {
            String content = this.wikiEngine_.back();
            WebEngine webEngine = this.webView.getEngine();
            webEngine.loadContent(content);
            HashMap<String, PageData> map = this.wikiEngine_.getPageDataMap();
            boolean canEdit = map.size() != 1;
            this.choiceViewHyperlinkEdit.setDisable(canEdit);
            this.menuItemNew.setDisable(false);
            this.AnchorPaneEdit.setVisible(false);
            this.AnchorPaneContentList.setVisible(false);
            this.AnchorPaneWebView.setVisible(true);
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
            this.webViewMenuAnchorPaneButtonBack.setDisable(!this.wikiEngine_.canBack());
            this.webViewMenuAnchorPaneButtonForward.setDisable(!this.wikiEngine_.canForward());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonForward(ActionEvent event) {
        try {
            String content = this.wikiEngine_.forward();
            WebEngine webEngine = this.webView.getEngine();
            webEngine.loadContent(content);
            HashMap<String, PageData> map = this.wikiEngine_.getPageDataMap();
            boolean canEdit = map.size() != 1;
            this.choiceViewHyperlinkEdit.setDisable(canEdit);
            this.menuItemNew.setDisable(false);
            this.AnchorPaneEdit.setVisible(false);
            this.AnchorPaneContentList.setVisible(false);
            this.AnchorPaneWebView.setVisible(true);
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
            this.webViewMenuAnchorPaneButtonBack.setDisable(!this.wikiEngine_.canBack());
            this.webViewMenuAnchorPaneButtonForward.setDisable(!this.wikiEngine_.canForward());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonReload(ActionEvent event) {
        try {
            this.wikiEngine_.refreshSession();
            this.loadWikiContent();
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonHome(ActionEvent event) {
        try {
            this.wikiEngine_.setPageDataMap("MainPage");
            this.loadWikiContent();
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedHyperlinkRedraw() {
        try {
            this.buildTableViewPageList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedWebViewHyperlinkMain() {
        this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
        this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
        this.webViewAnchorPaneMain.setVisible(true);
        this.webViewAnchorPaneHistory.setVisible(false);
    }

    @FXML
    public void onMouseClickedWebViewHyperlinkHistory() {
        try {
            ObservableList<Node> breadcrumbsList = this.webViewHistoryBreadcrumbsPane.getChildren();
            breadcrumbsList.clear();
            breadcrumbsList.add(this.createBreadcrumbsLabel("key.History.Breadcrumbs.List"));
            ObservableList<VersionHistoryListItem> list = this.webViewHistoryListView.getItems();
            list.clear();
            VersionIterator versionIter = this.wikiEngine_.getVersionHistory();
            versionIter.skip(1L);
            while (versionIter.hasNext()) {
                Version version = versionIter.nextVersion();
                NodeIterator nodeIter = version.getNodes();
                while (nodeIter.hasNext()) {
                    javax.jcr.Node node = nodeIter.nextNode();
                    list.add(new VersionHistoryListItem(version, version.getCreated().getTime(), node));
                }
            }
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkInactive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkActive");
            this.webViewAnchorPaneMain.setVisible(false);
            this.webViewAnchorPaneHistory.setVisible(true);
            this.webViewHistoryListView.setVisible(true);
            this.webViewHistoryAnchorPaneContent.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonRestoreVersion(ActionEvent event) {
        try {
            VersionHistoryListItem item = (VersionHistoryListItem)this.webViewHistoryAnchorPaneContent.getUserData();
            this.wikiEngine_.restoreVersion(item.getVersion());
            this.wikiEngine_.refreshSession();
            this.loadWikiContent();
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonDeletePages(ActionEvent event) {
        try {
            ObservableList<PageData> pageDataList = this.tableViewContentList.getItems();
            for (PageData pageData : pageDataList) {
                if (!pageData.checkProperty().getValue().booleanValue()) continue;
                this.wikiEngine_.deletePage(pageData);
            }
            HashMap<String, PageData> map = this.wikiEngine_.queryPageTitle("MainPage");
            if (map.size() < 1) {
                PageData pageData = new PageData();
                pageData.setNamespace("Main");
                pageData.setTitle("MainPage");
                pageData = this.wikiEngine_.checkin(pageData);
            }
            this.wikiEngine_.clearHistory();
            this.wikiEngine_.setPageDataMap("MainPage");
            this.loadWikiContent();
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonChoiceFile(ActionEvent event) {
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select " + this.textFieldTitle.getText());
            File file = fileChooser.showOpenDialog(this.stage_);
            if (file != null) {
                this.textFieldAttachFile.setText(file.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onMouseClickedSidemenuHyperlinkHelp() {
        try {
            this.helpWindow_.setWikiRepository(this.wikiEngine_.getWikiRepository());
            this.helpWindow_.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonPreview(ActionEvent event) {
        try {
            this.previewWindow_.setWikiRepository(this.wikiEngine_.getWikiRepository());
            this.previewWindow_.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonSave(ActionEvent event) {
        try {
            String title = this.textFieldTitle.getText();
            if (title.isEmpty()) {
                Stage stage = new Stage(StageStyle.UTILITY);
                stage.initOwner(this.stage_);
                stage.initModality(Modality.WINDOW_MODAL);
                AlertDialog alertDialog = new AlertDialog(AlertDialog.MessageType.AlertTitleEmpty);
                alertDialog.showDialog(stage, this.resourceBundle_);
            } else {
                PageData pageData = (PageData)this.AnchorPaneEdit.getUserData();
                if (this.editMode_ == EditMode.NEW && pageData == null) {
                    pageData = new PageData();
                    pageData.setNamespace("Main");
                }
                pageData.setTitle(title);
                pageData.setContent(this.textAreaContents.getText());
                String filename = this.textFieldAttachFile.getText();
                if (!filename.isEmpty()) {
                    pageData.setFileData(new File(filename));
                }
                pageData = this.wikiEngine_.checkin(pageData);
                this.editMode_ = EditMode.NONE;
                this.previewWindow_.hide();
                this.wikiEngine_.setPageDataMap(pageData);
                this.loadWikiContent();
                this.menuItemNew.setDisable(false);
                this.AnchorPaneWebView.setVisible(true);
                this.AnchorPaneEdit.setVisible(false);
                this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
                this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
                this.webViewAnchorPaneMain.setVisible(true);
                this.webViewAnchorPaneHistory.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonCancel(ActionEvent event) {
        try {
            if (this.showConfirmEditCancelDialog() == DialogBase.CloseType.OK) {
                this.editMode_ = EditMode.NONE;
                this.wikiEngine_.cancelCheckout();
                this.previewWindow_.hide();
                this.menuItemNew.setDisable(false);
                this.AnchorPaneWebView.setVisible(true);
                this.AnchorPaneEdit.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DialogBase.CloseType showConfirmEditCancelDialog() throws Exception {
        AlertDialog alertDialog = new AlertDialog(AlertDialog.MessageType.ConfirmEditCancel);
        return alertDialog.showDialog(this.stage_, this.resourceBundle_);
    }

    public void buildEditView(String title) {
        this.buildEditView(EditMode.NEW, title);
    }

    public void buildEditView(EditMode editMode, String title) {
        try {
            String content = "";
            String namespace = "";
            this.editMode_ = editMode;
            if (editMode == EditMode.MODIFY) {
                HashMap<String, PageData> map = this.wikiEngine_.getPageDataMap();
                PageData pageData = map.values().iterator().next();
                this.AnchorPaneEdit.setUserData(pageData);
                this.wikiEngine_.checkout();
                title = pageData.getTitle();
                content = pageData.getContent();
                namespace = pageData.getNamespace();
            } else {
                this.AnchorPaneEdit.setUserData(null);
                if (this.editMode_ == EditMode.NEW && !title.isEmpty()) {
                    PageData pageData = new PageData();
                    String pageTitle = title;
                    pageData.setNamespace("Main");
                    if (title.contains(":")) {
                        namespace = title.substring(0, title.indexOf(":"));
                    }
                    if (!namespace.isEmpty()) {
                        if (this.wikiEngine_.isContainsNamespaceList(namespace)) {
                            pageData.setNamespace(namespace);
                            pageTitle = title.substring(namespace.length() + ":".length(), title.length());
                        } else {
                            pageTitle = title;
                        }
                    }
                    pageData.setTitle(pageTitle);
                    this.AnchorPaneEdit.setUserData(pageData);
                    title = pageData.getTitle();
                    namespace = pageData.getNamespace();
                }
            }
            boolean cannotAttacheFile = !namespace.equals("File");
            this.textFieldAttachFile.setDisable(cannotAttacheFile);
            this.labelAttacheFile.setDisable(cannotAttacheFile);
            this.buttonChoiceFile.setDisable(cannotAttacheFile);
            this.textFieldTitle.setText(title);
            this.textAreaContents.setText(content);
            this.textFieldAttachFile.setText("");
            this.menuItemNew.setDisable(true);
            this.AnchorPaneWebView.setVisible(false);
            this.AnchorPaneContentList.setVisible(false);
            this.AnchorPaneEdit.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PageData getLatestContents() throws Exception {
        PageData pageData = new PageData();
        PageData editData = (PageData)this.AnchorPaneEdit.getUserData();
        pageData.setTitle(this.textFieldTitle.getText());
        pageData.setContent(this.textAreaContents.getText());
        String namespace = editData != null ? editData.getNamespace() : "Main";
        pageData.setNamespace(namespace);
        String pathname = this.textFieldAttachFile.getText();
        if (pathname != null && !pathname.isEmpty()) {
            pageData.setFileData(new File(pathname));
        }
        return pageData;
    }

    public void loadWikiContent() {
        try {
            WebEngine webEngine = this.webView.getEngine();
            webEngine.loadContent(this.wikiEngine_.parse());
            HashMap<String, PageData> map = this.wikiEngine_.getPageDataMap();
            boolean canEdit = map.size() != 1;
            this.choiceViewHyperlinkEdit.setDisable(canEdit);
            this.menuItemNew.setDisable(false);
            this.AnchorPaneEdit.setVisible(false);
            this.AnchorPaneContentList.setVisible(false);
            this.AnchorPaneWebView.setVisible(true);
            this.webViewMenuAnchorPaneButtonBack.setDisable(!this.wikiEngine_.canBack());
            this.webViewMenuAnchorPaneButtonForward.setDisable(!this.wikiEngine_.canForward());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jumpToSectionLink(EventTarget target) throws Exception {
        HTMLAnchorElement anchor = (HTMLAnchorElement)((Object)target);
        String href = anchor.getAttribute("href");
        String pageTitle = URLDecoder.decode(href, "UTF-8");
        String sectionName = pageTitle.substring(pageTitle.indexOf("#") + "#".length());
        this.webView.getEngine().executeScript("scrollTo('" + sectionName + "')");
    }

    public WebView getWebView() {
        return this.webView;
    }

    public ImageView getImageViewLoading() {
        return this.ImageViewLoading;
    }

    private void doSearchWiki() throws Exception {
        String key = this.webViewMenuAnchorPaneTextFieldSearchWiki.getText();
        if (!key.isEmpty()) {
            HashMap<String, PageData> map = this.wikiEngine_.queryPageFullTextSearch(key);
            this.wikiEngine_.setPageDataMap(map);
            this.loadWikiContent();
            this.webViewHyperlinkMain.setId("webViewMainHyperlinkActive");
            this.webViewHyperlinkHistory.setId("webViewMainHyperlinkInactive");
            this.webViewAnchorPaneMain.setVisible(true);
            this.webViewAnchorPaneHistory.setVisible(false);
        }
    }

    private PageData getSelectingPageData() throws Exception {
        PageData pageData = null;
        if (this.AnchorPaneContentList.isVisible()) {
            TableView.TableViewSelectionModel selectedData = (TableView.TableViewSelectionModel)this.tableViewContentList.selectionModelProperty().getValue();
            pageData = (PageData)selectedData.getSelectedItem();
        } else if (this.AnchorPaneEdit.isVisible()) {
            pageData = (PageData)this.AnchorPaneEdit.getUserData();
        }
        return pageData;
    }

    private void buildComboBoxNamespace() throws Exception {
        ArrayList<String> namespaceList = this.wikiEngine_.getNamespaceList();
        ObservableList<String> items = this.comboBoxNamespace.getItems();
        items.clear();
        int index = 0;
        while (index < namespaceList.size()) {
            String item = namespaceList.get(index);
            items.add(item);
            if (item.equals("Main")) {
                this.comboBoxNamespace.getSelectionModel().select(index);
            }
            ++index;
        }
    }

    private void buildTableViewPageList() throws Exception {
        String namespace = (String)this.comboBoxNamespace.getSelectionModel().getSelectedItem();
        HashMap<String, PageData> pageMap = this.wikiEngine_.queryPageNamespace(namespace);
        ObservableList<PageData> observableList = FXCollections.observableArrayList();
        this.tableViewContentList.getItems().clear();
        for (String key : pageMap.keySet()) {
            observableList.add(pageMap.get(key));
        }
        this.tableViewContentList.setItems(observableList);
    }

    private void setLinkClickListner(WebEngine webEngine) {
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State oldState, Worker.State newState) {
                WebView webView = WikiMainWindowController.this.getWebView();
                EventListener listener = new EventListener(){

                    @Override
                    public void handleEvent(org.w3c.dom.events.Event event) {
                        try {
                            org.w3c.dom.events.MouseEvent mouseEvent = (org.w3c.dom.events.MouseEvent)event;
                            EventTarget target = mouseEvent.getCurrentTarget();
                            if (this.isExternalLink(target)) {
                                event.preventDefault();
                                this.externalLinkHandle(target);
                            } else {
                                this.internalLinkHandle(target);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    private boolean isExternalLink(EventTarget target) {
                        ArrayList<String> schemeList = new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add("http://");
                                this.add("https://");
                                this.add("file://");
                            }
                        };
                        HTMLAnchorElement aElem = (HTMLAnchorElement)((Object)target);
                        String href = aElem.getAttribute("href");
                        boolean isExternal = false;
                        for (String scheme : schemeList) {
                            if (!href.startsWith(scheme)) continue;
                            isExternal = true;
                            break;
                        }
                        return isExternal;
                    }

                    private void externalLinkHandle(EventTarget target) throws Exception {
                        String targetpath = target.toString();
                        if (targetpath.startsWith("file:///")) {
                            targetpath = URLDecoder.decode(targetpath, "UTF-8");
                        }
                        Desktop.getDesktop().browse(new URI(targetpath));
                    }

                    private void internalLinkHandle(EventTarget target) throws Exception {
                        HTMLAnchorElement anchor = (HTMLAnchorElement)((Object)target);
                        String href = anchor.getAttribute("href");
                        String pageTitle = URLDecoder.decode(href, "UTF-8");
                        String uuid = anchor.getAttribute("data-jcr_uuid");
                        HashMap<String, PageData> pageDataMap = uuid != null ? WikiMainWindowController.this.wikiEngine_.queryPageUUID(uuid) : WikiMainWindowController.this.wikiEngine_.queryPageTitle(pageTitle);
                        if (pageDataMap.size() == 1) {
                            WikiMainWindowController.this.wikiEngine_.setPageDataMap(pageDataMap);
                            WikiMainWindowController.this.loadWikiContent();
                        } else if (href.contains("#")) {
                            WikiMainWindowController.this.jumpToSectionLink(target);
                        } else {
                            WikiMainWindowController.this.buildEditView(href);
                        }
                    }
                };
                if (newState == Worker.State.SUCCEEDED) {
                    Document doc = webView.getEngine().getDocument();
                    NodeList listA = doc.getElementsByTagName("a");
                    int index = 0;
                    while (index < listA.getLength()) {
                        ((EventTarget)((Object)listA.item(index))).addEventListener("click", listener, false);
                        ++index;
                    }
                    WikiMainWindowController.this.getImageViewLoading().setVisible(false);
                    webView.setVisible(true);
                }
            }
        });
    }

    private Label createBreadcrumbsLabel(String key) {
        Label labelCrumbsList = new Label(this.resourceBundle_.getString(key));
        labelCrumbsList.setId("webViewBreadcrumbs");
        labelCrumbsList.setPrefHeight(40.0);
        return labelCrumbsList;
    }

    private Hyperlink createBreadcrumbsHyperlink(String key, EventHandler<ActionEvent> eventHandler) {
        Hyperlink linkCrumbsList = new Hyperlink(this.resourceBundle_.getString(key));
        linkCrumbsList.setId("webViewBreadcrumbs");
        linkCrumbsList.setPrefHeight(40.0);
        linkCrumbsList.setOnAction(eventHandler);
        return linkCrumbsList;
    }

    private static enum EditMode {
        NONE,
        NEW,
        MODIFY;

    }

    public class VersionHistoryListItem {
        private Version version_;
        private Date created_;
        private javax.jcr.Node node_;

        public VersionHistoryListItem(Version version, Date created, javax.jcr.Node node) {
            this.version_ = version;
            this.created_ = created;
            this.node_ = node;
        }

        public Version getVersion() {
            return this.version_;
        }

        public Date getCreated() {
            return this.created_;
        }

        public javax.jcr.Node getNode() {
            return this.node_;
        }
    }
}

