/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.WikiPreviewWindow;
import com.wiki.standalone.moxkiriya.WikiRepository;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.web.WebView;

public class WikiPreviewWindowController
implements Initializable {
    private WikiEngine wikiEngine_;
    private WikiPreviewWindow wikiPreviewWindow_;
    @FXML
    private Button buttonReload;
    @FXML
    private Button buttonClose;
    @FXML
    private WebView webView;

    @Override
    public void initialize(URL url, ResourceBundle resource) {
        this.wikiEngine_ = new WikiEngine();
    }

    public void setWikiPreviewWindow(WikiPreviewWindow previewWindow) {
        this.wikiPreviewWindow_ = previewWindow;
    }

    public void setWikiRepository(WikiRepository wikiRepository) {
        this.wikiEngine_.setWikiRepository(wikiRepository);
    }

    public void loadWikiContent(PageData pageData) {
        try {
            HashMap<String, PageData> map = new HashMap<String, PageData>();
            map.put("preview", pageData);
            this.wikiEngine_.setPageDataMap(map);
            String content = this.wikiEngine_.parse(pageData);
            this.webView.getEngine().loadContent(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonReload(ActionEvent event) {
        try {
            PageData pageData = this.wikiPreviewWindow_.getLatestContents();
            this.loadWikiContent(pageData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void onActionButtonClose(ActionEvent event) {
        ((Node)event.getSource()).getScene().getWindow().hide();
    }
}

