/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya;

import com.wiki.standalone.moxkiriya.PageData;
import com.wiki.standalone.moxkiriya.SettingManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import javax.naming.InitialContext;
import org.apache.jackrabbit.core.jndi.RegistryHelper;
import org.apache.jackrabbit.value.StringValue;

public class WikiRepository {
    public static final String REPOSITORY_CUSTER_FILENAME = "repository_cluster_derby.xml";
    public static final String REPOSITORY_LOCAL_FILENAME = "repository_local.xml";
    public static final String REOPSITORY_DIRNAME = "Repository";
    public static final String NAMESPACE_MOXKI = "moxki";
    public static final String NAMESPACE_MOXKI_URI = "https://osdn.net/projects/moxkiriya7/moxki/1.0";
    public static final String NODE_WIKIROOT = "moxki:wikiroot";
    public static final String NODE_NAMESPACE = "moxki:namespacelist";
    public static final String PROPERTY_NAMESPACE = "moxki:namespace";
    public static final String PROPERTY_MAIN = "Main";
    public static final String PROPERTY_CATEGORY = "Category";
    public static final String PROPERTY_FILE = "File";
    public static final String PROPERTY_HELP = "Help";
    public static final String NODE_PAGES = "moxki:pages";
    public static final String NODE_PAGE = "moxki:page";
    public static final String PROPERTY_TITLE = "moxki:title";
    public static final String PROPERTY_CONTENT = "moxki:content";
    public static final String PROPERTY_category = "moxki:category";
    public static final String NODE_FILE = "moxki:file";
    private String repositoryHomeDir_;
    private String repositoryFile_;
    private static Hashtable<String, String> envHashTable = new Hashtable<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
            this.put("java.naming.provider.url", "localhost");
        }
    };
    private Repository repository_;
    private Session session_;

    public WikiRepository(File wikirootPath) throws Exception {
        SettingManager settingMgr = SettingManager.getInstance();
        this.setSystemProperties();
        String configXML = settingMgr.get("clustersetting").equals("true") ? REPOSITORY_CUSTER_FILENAME : REPOSITORY_LOCAL_FILENAME;
        this.repositoryHomeDir_ = settingMgr.getAbsolutePath(REOPSITORY_DIRNAME);
        this.repositoryFile_ = settingMgr.getAbsolutePath(configXML);
        InitialContext initialContext = new InitialContext(envHashTable);
        RegistryHelper.registerRepository(initialContext, "repo", this.repositoryFile_, this.repositoryHomeDir_, true);
        this.repository_ = (Repository)initialContext.lookup("repo");
        this.session_ = this.repository_.login((Credentials)null);
    }

    public void closeSession() {
        this.session_.logout();
    }

    public void buildWikiRepository(PageData pageData) throws Exception {
        Workspace workspace = this.session_.getWorkspace();
        try {
            NamespaceRegistry nsRegistry = workspace.getNamespaceRegistry();
            nsRegistry.getPrefix(NAMESPACE_MOXKI_URI);
        }
        catch (NamespaceException e) {
            workspace.getNamespaceRegistry().registerNamespace(NAMESPACE_MOXKI, NAMESPACE_MOXKI_URI);
            Node root = this.session_.getRootNode();
            Node wikiroot = root.addNode(NODE_WIKIROOT);
            Node namespace = wikiroot.addNode(NODE_NAMESPACE);
            namespace.setProperty(PROPERTY_NAMESPACE, new Value[]{new StringValue(PROPERTY_MAIN), new StringValue(PROPERTY_CATEGORY), new StringValue(PROPERTY_FILE), new StringValue(PROPERTY_HELP)});
            wikiroot.addNode(NODE_PAGES);
            this.checkin(pageData);
            InputStream in = this.getClass().getResourceAsStream("resources/Help.xml");
            this.importSystemView(in);
        }
    }

    public Node addPageNode(PageData pageData) throws Exception {
        Node root = this.session_.getRootNode();
        Node wikiroot = root.getNode(NODE_WIKIROOT);
        Node pagesNode = wikiroot.getNode(NODE_PAGES);
        Node pageNode = pagesNode.addNode(NODE_PAGE);
        pageNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        pageNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        return this.transformPageDataToNode(pageData, pageNode);
    }

    public Node transformPageDataToNode(PageData pageData, Node node) throws Exception {
        node.setProperty(PROPERTY_NAMESPACE, new StringValue(pageData.getNamespace()));
        node.setProperty(PROPERTY_TITLE, new StringValue(pageData.getTitle()));
        node.setProperty(PROPERTY_CONTENT, new StringValue(pageData.getContent()));
        ArrayList<String> categories = pageData.getCategories();
        Value[] values = new Value[]{new StringValue("")};
        if (categories.size() > 0) {
            values = new Value[categories.size()];
            int count = 0;
            while (count < categories.size()) {
                values[count] = new StringValue(categories.get(count));
                ++count;
            }
        }
        node.setProperty(PROPERTY_category, values);
        PageData.FileData fileData = pageData.getFileData();
        if (fileData != null) {
            Node fileNode;
            if (node.hasNode(NODE_FILE)) {
                fileNode = node.getNode(NODE_FILE);
            } else {
                fileNode = node.addNode(NODE_FILE, "{http://www.jcp.org/jcr/nt/1.0}file");
                fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
            }
            Node nodeResource = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            ValueFactory valueFactory = this.session_.getValueFactory();
            nodeResource.setProperty("{http://www.jcp.org/jcr/1.0}data", valueFactory.createBinary(fileData.getInputStream()));
            nodeResource.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", new StringValue(fileData.getMimeType()));
            nodeResource.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", valueFactory.createValue(fileData.getLastModified()));
            if (fileData.getMimeType().startsWith("text/")) {
                nodeResource.setProperty("{http://www.jcp.org/jcr/1.0}encoding", new StringValue("UTF-8"));
            }
        }
        return node;
    }

    private HashMap<String, PageData> executeQuery(String sql) throws Exception {
        Workspace workspace = this.session_.getWorkspace();
        QueryManager queryMgr = workspace.getQueryManager();
        Query query = queryMgr.createQuery(sql, "JCR-SQL2");
        NodeIterator iter = query.execute().getNodes();
        return this.convertNodeIteratorToPageDataMap(iter);
    }

    public HashMap<String, PageData> queryPageNamespace(String namespace) throws Exception {
        return this.executeQuery("SELECT * \tFROM [nt:unstructured] WHERE ISDESCENDANTNODE([/moxki:wikiroot/moxki:pages]) AND [moxki:namespace] = '" + namespace + "'");
    }

    public HashMap<String, PageData> queryPageUUID(String uuid) throws Exception {
        return this.executeQuery("SELECT * \tFROM [nt:unstructured] WHERE ISDESCENDANTNODE([/moxki:wikiroot/moxki:pages]) AND [{http://www.jcp.org/jcr/1.0}uuid] = '" + uuid + "'");
    }

    public HashMap<String, PageData> queryPageTitle(String pageTitle) throws Exception {
        String namespace = PROPERTY_MAIN;
        String title = pageTitle;
        if (pageTitle.contains(":")) {
            namespace = pageTitle.substring(0, pageTitle.indexOf(":"));
            title = pageTitle.substring(pageTitle.indexOf(":") + ":".length());
        }
        return this.queryPageTitle(title, namespace);
    }

    public HashMap<String, PageData> queryPageTitle(String pageTitle, String namespace) throws Exception {
        return this.executeQuery("SELECT * \tFROM [nt:unstructured] WHERE ISDESCENDANTNODE([/moxki:wikiroot/moxki:pages]) AND [moxki:namespace] = '" + namespace + "'" + " AND" + " [" + PROPERTY_TITLE + "] = '" + pageTitle + "'");
    }

    public HashMap<String, PageData> queryPageFullTextSearch(String searchKey) throws Exception {
        return this.executeQuery("SELECT * \tFROM [nt:unstructured] WHERE ISDESCENDANTNODE([/moxki:wikiroot/moxki:pages]) AND  CONTAINS([moxki:title], '" + searchKey + "')" + " OR " + " CONTAINS([" + PROPERTY_CONTENT + "], '" + searchKey + "')");
    }

    public HashMap<String, PageData> convertNodeIteratorToPageDataMap(NodeIterator nodeIter) throws Exception {
        HashMap<String, PageData> pageDataMap = new HashMap<String, PageData>();
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            Version baseVersion = this.getBaseVersion(node);
            PageData pageData = new PageData(node);
            pageData.setBaseVersion(baseVersion);
            pageDataMap.put(node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString(), pageData);
        }
        return pageDataMap;
    }

    public Value[] getNamespaceList() throws Exception {
        Node namespace = this.session_.getNode("/moxki:wikiroot/moxki:namespacelist");
        return namespace.getProperty(PROPERTY_NAMESPACE).getValues();
    }

    public void checkout(PageData pageData) throws Exception {
        Node node = pageData.getNode();
        if (node != null) {
            this.session_.refresh(false);
            Workspace workspace = this.session_.getWorkspace();
            VersionManager versionMgr = workspace.getVersionManager();
            versionMgr.checkout(node.getPath());
        }
    }

    public PageData checkin(PageData pageData) throws Exception {
        String uuid;
        Workspace workspace = this.session_.getWorkspace();
        VersionManager versionMgr = workspace.getVersionManager();
        Node node = pageData.getNode();
        if (node == null) {
            node = this.addPageNode(pageData);
            this.session_.save();
            versionMgr.checkout(node.getPath());
        } else {
            uuid = node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
            node = this.transformPageDataToNode(pageData, this.session_.getNodeByIdentifier(uuid));
            this.session_.save();
        }
        versionMgr.checkin(node.getPath());
        this.createCategoryPages(node);
        uuid = node.getProperty("{http://www.jcp.org/jcr/1.0}uuid").getString();
        return new PageData(this.session_.getNodeByIdentifier(uuid));
    }

    public void cancelCheckout(PageData pageData) throws Exception {
        String path;
        Workspace workspace;
        VersionManager versionMgr;
        Node node = pageData.getNode();
        if (node != null && (versionMgr = (workspace = this.session_.getWorkspace()).getVersionManager()).isCheckedOut(path = node.getPath())) {
            versionMgr.restore(versionMgr.getBaseVersion(path), true);
        }
    }

    public void deletePage(PageData pageData) throws Exception {
        pageData.getNode().remove();
        this.session_.save();
    }

    public void refreshSession() throws RepositoryException {
        this.session_.refresh(false);
    }

    private void setSystemProperties() throws Exception {
        SettingManager settingMgr = SettingManager.getInstance();
        String macAddress = this.getMacAddress();
        String username = System.getProperty("user.name");
        String approot = settingMgr.get("wikiroot");
        String partyName = settingMgr.getSelectedParty();
        System.setProperty("cluster.id", String.valueOf(String.valueOf(macAddress.hashCode()) + "-" + partyName + "-" + username));
        System.setProperty("wiki.root", approot);
        if (settingMgr.get("clustersetting").equals("true")) {
            System.setProperty("party.name", partyName);
            System.setProperty("cluster.setting", "TRUE");
            System.setProperty("dbserver.url", settingMgr.get("dbserverurl"));
            System.setProperty("dbserver.port", settingMgr.get("dbserverport"));
            System.setProperty("jdbc.driver", settingMgr.get("jdbcdriver"));
        } else {
            System.setProperty("cluster.setting", "FALSE");
            System.setProperty("dbserver.url", "");
            System.setProperty("dbserver.port", "");
            System.setProperty("jdbc.driver", "");
        }
    }

    private String getMacAddress() throws Exception {
        StringBuffer buf = new StringBuffer();
        Enumeration<NetworkInterface> nicList = NetworkInterface.getNetworkInterfaces();
        while (nicList.hasMoreElements()) {
            byte[] macAddress;
            NetworkInterface nic = nicList.nextElement();
            if (nic.getName().equals("lo") || (macAddress = nic.getHardwareAddress()) == null) continue;
            byte[] byArray = macAddress;
            int n = macAddress.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                buf.append(String.format("%02X-", b));
                ++n2;
            }
            break block0;
        }
        return buf.toString();
    }

    private void createCategoryPages(Node node) throws Exception {
        Value[] categories;
        Workspace workspace = this.session_.getWorkspace();
        VersionManager versionMgr = workspace.getVersionManager();
        Value[] valueArray = categories = node.getProperty(PROPERTY_category).getValues();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            HashMap<String, PageData> map;
            Value category = valueArray[n2];
            String title = category.getString();
            if (!title.isEmpty() && (map = this.queryPageTitle(title, PROPERTY_CATEGORY)).size() == 0) {
                PageData pageData = new PageData();
                pageData.setNamespace(PROPERTY_CATEGORY);
                pageData.setTitle(title);
                Node categoryNode = this.addPageNode(pageData);
                this.session_.save();
                versionMgr.checkout(categoryNode.getPath());
                versionMgr.checkin(categoryNode.getPath());
            }
            ++n2;
        }
    }

    public boolean isContainsNamespaceList(String namespace) throws Exception {
        Node root = this.session_.getRootNode();
        Node wikiroot = root.getNode(NODE_WIKIROOT);
        Node namespaceNode = wikiroot.getNode(NODE_NAMESPACE);
        Value[] list = namespaceNode.getProperty(PROPERTY_NAMESPACE).getValues();
        boolean isContains = false;
        Value[] valueArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Value entry = valueArray[n2];
            if (entry.getString().equals(namespace)) {
                isContains = true;
                break;
            }
            ++n2;
        }
        return isContains;
    }

    public VersionIterator getVersionHistory(String uuid) throws Exception {
        HashMap<String, PageData> nodeMap = this.queryPageUUID(uuid);
        PageData pageData = nodeMap.values().iterator().next();
        Node node = pageData.getNode();
        Workspace workspace = this.session_.getWorkspace();
        VersionManager versionMgr = workspace.getVersionManager();
        VersionHistory versionHistory = versionMgr.getVersionHistory(node.getPath());
        return versionHistory.getAllVersions();
    }

    public Version getBaseVersion(Node node) throws Exception {
        Workspace workspace = this.session_.getWorkspace();
        VersionManager versionMgr = workspace.getVersionManager();
        return versionMgr.getBaseVersion(node.getPath());
    }

    public void restoreVersion(Version version, Node node) throws Exception {
        Workspace workspace = this.session_.getWorkspace();
        VersionManager versionMgr = workspace.getVersionManager();
        versionMgr.restore(version, true);
    }

    public void importSystemView(File outputFile) throws Exception {
        this.importSystemView(new FileInputStream(outputFile));
    }

    public void importSystemView(InputStream inStream) throws Exception {
        try {
            Value[] namespaces;
            Node root = this.session_.getRootNode();
            Node wikiroot = root.getNode(NODE_WIKIROOT);
            Node pagesNode = wikiroot.getNode(NODE_PAGES);
            this.session_.importXML(pagesNode.getPath(), inStream, 1);
            this.session_.save();
            Node namespaceNode = wikiroot.getNode(NODE_NAMESPACE);
            Value[] valueArray = namespaces = namespaceNode.getProperty(PROPERTY_NAMESPACE).getValues();
            int n = namespaces.length;
            int n2 = 0;
            while (n2 < n) {
                Value namespace = valueArray[n2];
                HashMap<String, PageData> map = this.queryPageNamespace(namespace.getString());
                for (PageData pageData : map.values()) {
                    this.checkout(pageData);
                    this.checkin(pageData);
                }
                ++n2;
            }
        }
        finally {
            inStream.close();
        }
    }

    public void exportSystemView(File outputFile) throws Exception {
        try (FileOutputStream outStream = new FileOutputStream(outputFile);){
            Node root = this.session_.getRootNode();
            Node wikiroot = root.getNode(NODE_WIKIROOT);
            Node pagesNode = wikiroot.getNode(NODE_PAGES);
            this.session_.exportSystemView(pagesNode.getPath(), outStream, false, false);
        }
    }
}

