/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.dialog;

import com.wiki.standalone.moxkiriya.ResourceManager;
import com.wiki.standalone.moxkiriya.dialog.AlertDialog;
import com.wiki.standalone.moxkiriya.dialog.DialogBase;
import com.wiki.standalone.moxkiriya.dialog.DialogControllerBase;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class AlertDialogController
extends DialogControllerBase {
    @FXML
    private ImageView ImageViewIcon;
    @FXML
    private Label labelMessage;
    @FXML
    private Label labelDetails;
    @FXML
    private Button buttonCancel;
    private DialogBase.CloseType closeType_;
    private static final LinkedHashMap<AlertDialog.MessageType, DialogProperty> dialogPropertyTable = new LinkedHashMap<AlertDialog.MessageType, DialogProperty>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(AlertDialog.MessageType.ConfirmEditCancel, new DialogProperty("key.Dialog.Message.Cancel.Editing", "key.Dialog.Detail.Cancel.Editing", AlertDialog.DialogType.Confirm));
            this.put(AlertDialog.MessageType.AlertTitleEmpty, new DialogProperty("key.Dialog.Message.Empty.Title", "key.Dialog.Detail.Input.Title", AlertDialog.DialogType.Alert, AlertDialog.ButtoType.OK));
            this.put(AlertDialog.MessageType.SuccessImport, new DialogProperty("key.Dialog.Import.Result.Title", "key.Dialog.Detail.Import.Success", AlertDialog.DialogType.Info, AlertDialog.ButtoType.OK));
            this.put(AlertDialog.MessageType.FailureImport, new DialogProperty("key.Dialog.Import.Result.Title", "key.Dialog.Detail.Import.Failure", AlertDialog.DialogType.Error, AlertDialog.ButtoType.OK));
            this.put(AlertDialog.MessageType.SuccessExport, new DialogProperty("key.Dialog.Export.Result.Title", "key.Dialog.Detail.Export.Success", AlertDialog.DialogType.Info, AlertDialog.ButtoType.OK));
            this.put(AlertDialog.MessageType.FailureExport, new DialogProperty("key.Dialog.Export.Result.Title", "key.Dialog.Detail.Export.Failure", AlertDialog.DialogType.Error, AlertDialog.ButtoType.OK));
        }
    };

    public void setMessageType(AlertDialog.MessageType msgType) throws MalformedURLException {
        DialogProperty dialogProperty = dialogPropertyTable.get((Object)msgType);
        if (dialogProperty != null) {
            this.labelMessage.setText(this.resource_.getString(dialogProperty.messageResourceKey_));
            this.labelDetails.setText(this.resource_.getString(dialogProperty.detailResourceKey_));
            Image image = ResourceManager.IconTable.get((Object)dialogProperty.dialogType_);
            this.ImageViewIcon.setImage(image);
            if (dialogProperty.buttonType_ == AlertDialog.ButtoType.OK) {
                this.buttonCancel.setVisible(false);
            } else {
                this.buttonCancel.setVisible(true);
            }
        }
    }

    @Override
    public DialogBase.CloseType getCloseType() {
        return this.closeType_;
    }

    @FXML
    public void onActionButtonOK(ActionEvent event) {
        this.closeType_ = DialogBase.CloseType.OK;
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    @FXML
    public void onActionButtonCancel(ActionEvent event) {
        this.closeType_ = DialogBase.CloseType.Cancel;
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    static class DialogProperty {
        String messageResourceKey_;
        String detailResourceKey_;
        AlertDialog.DialogType dialogType_;
        AlertDialog.ButtoType buttonType_;

        DialogProperty(String messageResourceKey, String detailResourceKey, AlertDialog.DialogType dialogType) {
            this(messageResourceKey, detailResourceKey, dialogType, AlertDialog.ButtoType.CANCEL_OK);
        }

        DialogProperty(String messageResourceKey, String detailResourceKey, AlertDialog.DialogType dialogType, AlertDialog.ButtoType buttonType) {
            this.messageResourceKey_ = messageResourceKey;
            this.detailResourceKey_ = detailResourceKey;
            this.dialogType_ = dialogType;
            this.buttonType_ = buttonType;
        }
    }
}

