/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.dialog;

import com.wiki.standalone.moxkiriya.SettingManager;
import com.wiki.standalone.moxkiriya.dialog.ConfigSettingsDialog;
import com.wiki.standalone.moxkiriya.dialog.DialogBase;
import com.wiki.standalone.moxkiriya.dialog.DialogControllerBase;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;

public class SelectPartyDialogController
extends DialogControllerBase {
    @FXML
    private TableView<PartyProperty> tableViewPartyList;
    @FXML
    private TableColumn<PartyProperty, Boolean> tableColumnSelect;
    @FXML
    private TableColumn<PartyProperty, String> tableColumnPartyName;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonOK;
    @FXML
    private Button buttonAddNewParty;
    private String selectedParty_;
    private ToggleGroup toggleGroupSelect_;
    private DialogBase.CloseType closeType_;
    private Stage stage_;

    @Override
    public void initialize(URL url, ResourceBundle resource) {
        super.initialize(url, resource);
        this.buttonOK.setDisable(true);
        this.toggleGroupSelect_ = new ToggleGroup();
        this.setCellFactory(this.tableColumnSelect, this.toggleGroupSelect_, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                RadioButton target = (RadioButton)event.getTarget();
                PartyProperty partyProperty = (PartyProperty)target.getUserData();
                if (target.isSelected()) {
                    SelectPartyDialogController.this.buttonOK.setDisable(false);
                    SelectPartyDialogController.this.selectedParty_ = partyProperty.partyNameProperty().getValue();
                }
            }
        });
        this.setCellFactory(this.tableColumnPartyName, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                Hyperlink target = (Hyperlink)event.getTarget();
                PartyProperty partyProperty = (PartyProperty)target.getUserData();
                String partyName = partyProperty.partyName_.get();
                try {
                    if (SelectPartyDialogController.this.showConfigSettingsDialog(SelectPartyDialogController.this.stage_, partyName) == DialogBase.CloseType.OK) {
                        SettingManager settingMgr = SettingManager.getInstance();
                        String path = settingMgr.get("MOXKIRIYA_USER_DIR");
                        settingMgr.loadSettingFiles(path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.buildTableViewPartyList();
        SettingManager settingMgr = SettingManager.getInstance();
        String defaultParty = settingMgr.getSelectedParty();
        if (defaultParty != null) {
            this.buttonCancel.setDisable(false);
        }
    }

    public void setStage(Stage stage) {
        this.stage_ = stage;
    }

    @Override
    public DialogBase.CloseType getCloseType() {
        return this.closeType_;
    }

    @FXML
    public void onActionButtonCancel(ActionEvent event) {
        this.closeType_ = DialogBase.CloseType.Cancel;
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    @FXML
    public void onActionButtonOK(ActionEvent event) {
        try {
            SettingManager settingMgr = SettingManager.getInstance();
            settingMgr.setSelectedParty(this.selectedParty_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.closeType_ = DialogBase.CloseType.OK;
        ((Node)event.getSource()).getScene().getWindow().hide();
    }

    @FXML
    public void onActionButtonAddNewParty(ActionEvent event) {
        try {
            this.showConfigSettingsDialog(this.stage_, null);
            SettingManager settingMgr = SettingManager.getInstance();
            Hashtable<String, Boolean> partyTable = settingMgr.getPartyTable();
            Set<String> keys = partyTable.keySet();
            ObservableList<PartyProperty> observableList = FXCollections.observableArrayList();
            for (String key : keys) {
                boolean isDefault = partyTable.get(key);
                PartyProperty partyProperty = new PartyProperty(isDefault, key);
                observableList.add(partyProperty);
            }
            this.tableViewPartyList.getItems().clear();
            this.tableViewPartyList.setItems(observableList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCellFactory(TableColumn<PartyProperty, Boolean> tableColumn, final ToggleGroup toggleGroup, final EventHandler<ActionEvent> eventHandler) {
        tableColumn.setCellFactory(new Callback<TableColumn<PartyProperty, Boolean>, TableCell<PartyProperty, Boolean>>(){

            @Override
            public TableCell<PartyProperty, Boolean> call(TableColumn<PartyProperty, Boolean> param) {
                TableCell<PartyProperty, Boolean> tableCell = new TableCell<PartyProperty, Boolean>(){

                    @Override
                    public void updateItem(Boolean select, boolean empty) {
                        super.updateItem(select, empty);
                        if (!empty) {
                            RadioButton radioButton = new RadioButton();
                            radioButton.setOnAction(eventHandler);
                            radioButton.setToggleGroup(toggleGroup);
                            this.setGraphic(radioButton);
                            int index = this.getIndex();
                            ObservableList items = this.getTableView().getItems();
                            radioButton.setUserData(items.get(index));
                        }
                    }
                };
                tableCell.setId("selectPartyRadioButtonTableCell");
                return tableCell;
            }
        });
    }

    private void setCellFactory(TableColumn<PartyProperty, String> tableColumn, final EventHandler<ActionEvent> eventHandler) {
        tableColumn.setCellFactory(new Callback<TableColumn<PartyProperty, String>, TableCell<PartyProperty, String>>(){

            @Override
            public TableCell<PartyProperty, String> call(TableColumn<PartyProperty, String> param) {
                TableCell<PartyProperty, String> tableCell = new TableCell<PartyProperty, String>(){

                    @Override
                    public void updateItem(String partyName, boolean empty) {
                        super.updateItem(partyName, empty);
                        if (!empty) {
                            Hyperlink hyperlink = new Hyperlink(partyName);
                            hyperlink.setOnAction(eventHandler);
                            this.setGraphic(hyperlink);
                            int index = this.getIndex();
                            ObservableList items = this.getTableView().getItems();
                            hyperlink.setUserData(items.get(index));
                        }
                    }
                };
                return tableCell;
            }
        });
    }

    private void buildTableViewPartyList() {
        this.tableColumnSelect.setCellValueFactory(new PropertyValueFactory("select"));
        this.tableColumnPartyName.setCellValueFactory(new PropertyValueFactory("partyName"));
        SettingManager settingMgr = SettingManager.getInstance();
        Hashtable<String, Boolean> partyTable = settingMgr.getPartyTable();
        Set<String> keys = partyTable.keySet();
        ObservableList<PartyProperty> observableList = FXCollections.observableArrayList();
        for (String key : keys) {
            boolean isDefault = partyTable.get(key);
            PartyProperty partyProperty = new PartyProperty(isDefault, key);
            observableList.add(partyProperty);
        }
        this.tableViewPartyList.setItems(observableList);
    }

    private DialogBase.CloseType showConfigSettingsDialog(Stage stage, String partyName) throws Exception {
        SettingManager settingMgr_ = SettingManager.getInstance();
        ConfigSettingsDialog dialog = new ConfigSettingsDialog(partyName);
        DialogBase.CloseType closeType = dialog.showDialog(stage, this.resource_);
        if (closeType == DialogBase.CloseType.OK) {
            Hashtable<String, String> settingsTable = dialog.getSettingsTable();
            String path = settingMgr_.get("MOXKIRIYA_USER_DIR");
            partyName = dialog.getPartyName();
            settingMgr_.putParty(partyName, dialog.getDefaultPartyCheckValue());
            settingMgr_.savePartyConfig(path);
            settingMgr_.saveSettingConfig(path, partyName, settingsTable);
        }
        return closeType;
    }

    public class PartyProperty {
        private SimpleBooleanProperty select_;
        private SimpleStringProperty partyName_;

        public PartyProperty(boolean aSelect, String aPartyName) {
            this.select_ = new SimpleBooleanProperty(aSelect);
            this.partyName_ = new SimpleStringProperty(aPartyName);
        }

        public BooleanProperty selectProperty() {
            return this.select_;
        }

        public StringProperty partyNameProperty() {
            return this.partyName_;
        }
    }
}

