/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockquoteBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiCodeBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiDefaultBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiHnBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiHrBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiOrderedListBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiPreBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiTOCBuilder;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiTableBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiUnorderedListBlockParser;
import java.util.LinkedHashMap;
import java.util.Set;

public class WikiBlockParserCreator {
    private WikiTOCBuilder wikiTOCBuilder_;
    private WikiEngine wikiEngine_;
    private LinkedHashMap<String, Creator> creatorMap = new LinkedHashMap<String, Creator>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("^==+..*==+$", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiHnBlockParser(wikiEngine, WikiBlockParserCreator.this.wikiTOCBuilder_);
                }
            });
            this.put("^----$", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiHrBlockParser(wikiEngine);
                }
            });
            this.put(WikiTableBlockParser.NOTATION_REGEX, new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiTableBlockParser(wikiEngine);
                }
            });
            this.put(WikiUnorderedListBlockParser.NOTATION_REGEX, new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiUnorderedListBlockParser(wikiEngine);
                }
            });
            this.put("^[ \t]*#+ +[^#]..*", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiOrderedListBlockParser(wikiEngine);
                }
            });
            this.put("^>..*", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiBlockquoteBlockParser(wikiEngine);
                }
            });
            this.put(".*<pre[ \t]*>.*.*", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiPreBlockParser(wikiEngine);
                }
            });
            this.put(".*<code[ \t]*>.*.*", new Creator(){

                @Override
                public WikiBlockParser create(WikiEngine wikiEngine) {
                    return new WikiCodeBlockParser(wikiEngine);
                }
            });
        }
    };

    public WikiBlockParserCreator(WikiEngine wikiEngine) {
        this.wikiTOCBuilder_ = new WikiTOCBuilder();
        this.wikiEngine_ = wikiEngine;
    }

    public WikiBlockParser create(String line) {
        WikiBlockParser parser = null;
        Set<String> keySet = this.creatorMap.keySet();
        for (String key : keySet) {
            if (!line.toLowerCase().matches(key)) continue;
            parser = this.creatorMap.get(key).create(this.wikiEngine_);
            break;
        }
        if (parser == null) {
            parser = new WikiDefaultBlockParser(this.wikiEngine_);
        }
        return parser;
    }

    public String getTOC(String firstLine) {
        return this.wikiTOCBuilder_.buildTOC(firstLine);
    }

    static interface Creator {
        public WikiBlockParser create(WikiEngine var1);
    }
}

