/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;
import java.io.BufferedReader;
import java.util.ArrayList;

public class WikiBodyBlockParser {
    private final String START_TAG = "<body>";
    private final String END_TAG = "</body>";
    private String titleHtml_;
    WikiBlockParserCreator blockParserCreator_;
    private String firstLine_ = null;
    private static final ArrayList<String> acceptElementList_ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("<code[ \t]*>.*");
            this.add("<*/[ \t]*code>.*");
            this.add("<pre[ \t]*>.*");
            this.add("<*/[ \t]*pre>.*");
        }
    };

    public WikiBodyBlockParser(WikiEngine wikiEngine) {
        this.blockParserCreator_ = new WikiBlockParserCreator(wikiEngine);
    }

    public void parsePageTitle(String title) {
        this.titleHtml_ = "<h1>" + title + "</h1>\n";
    }

    public String parse(BufferedReader reader) throws Exception {
        StringBuffer buf = new StringBuffer();
        this.startElementProcess(buf);
        buf.append(this.titleHtml_);
        String bodyBlock = this.parseCore(reader);
        buf.append(this.blockParserCreator_.getTOC(this.firstLine_));
        buf.append(bodyBlock);
        this.endElementProcess(buf);
        return buf.toString();
    }

    private String parsePreprocess(String line) {
        StringBuffer buf = new StringBuffer("");
        StringBuffer tagBuf = null;
        char[] lineCharArray = line.toCharArray();
        PreprocessStatus status = PreprocessStatus.INIT;
        int count = 0;
        while (count < lineCharArray.length) {
            if (status == PreprocessStatus.INIT) {
                if (lineCharArray[count] == '<') {
                    status = PreprocessStatus.OPEN;
                    tagBuf = new StringBuffer();
                    tagBuf.append(lineCharArray[count]);
                } else {
                    buf.append(lineCharArray[count]);
                }
            } else if (status == PreprocessStatus.OPEN) {
                tagBuf.append(lineCharArray[count]);
                if (lineCharArray[count] == '>') {
                    String tag = tagBuf.toString();
                    for (String accept : acceptElementList_) {
                        if (!tag.toLowerCase().matches(accept)) continue;
                        buf.append(tag);
                        tagBuf = null;
                    }
                    if (tagBuf != null) {
                        buf.append(tag.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                        tagBuf = null;
                    }
                    status = PreprocessStatus.INIT;
                }
            } else {
                buf.append(lineCharArray[count]);
            }
            ++count;
        }
        if (status == PreprocessStatus.OPEN) {
            String tag = tagBuf.toString();
            buf.append(tag.replaceAll("<", "&lt;"));
        }
        return buf.toString();
    }

    private String parseCore(BufferedReader reader) throws Exception {
        StringBuffer buf = new StringBuffer("");
        StringBuffer paragraphBuf = null;
        String line = null;
        ParseStatus status = ParseStatus.INIT;
        WikiBlockParser parser = null;
        while ((line = reader.readLine()) != null) {
            if (this.firstLine_ == null) {
                this.firstLine_ = line;
                if (this.firstLine_.equals("{{#TOC}}")) continue;
            }
            String processingline = this.parsePreprocess(line);
            do {
                if (status != ParseStatus.OPEN) {
                    status = ParseStatus.OPEN;
                    paragraphBuf = new StringBuffer();
                }
                if (parser == null) {
                    parser = this.blockParserCreator_.create(processingline);
                    processingline = parser.startElementProcess(processingline, paragraphBuf);
                }
                processingline = parser.parse(processingline, paragraphBuf);
                if (!parser.isBlockEnd()) continue;
                processingline = parser.endElementProcess(processingline, paragraphBuf);
                parser = null;
                if (!line.isEmpty()) continue;
                buf.append("<p>\n");
                buf.append(paragraphBuf + "\n");
                buf.append("</p>\n");
                status = ParseStatus.CLOSE;
                paragraphBuf = null;
            } while (!processingline.isEmpty());
        }
        if (status == ParseStatus.OPEN) {
            if (parser != null) {
                parser.endElementProcess(line, paragraphBuf);
            }
            buf.append("<p>\n");
            buf.append(paragraphBuf + "\n");
            buf.append("</p>\n");
            status = ParseStatus.CLOSE;
        }
        return buf.toString();
    }

    public void startElementProcess(StringBuffer buf) {
        buf.append("<body>\n");
    }

    public void endElementProcess(StringBuffer buf) {
        buf.append("</body>\n");
    }

    static enum ParseStatus {
        INIT,
        OPEN,
        CLOSE;

    }

    static enum PreprocessStatus {
        INIT,
        OPEN,
        CLOSE;

    }
}

