/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;

public class WikiOrderedListBlockParser
extends WikiBlockParserBase {
    private static final String START_TAG = "<div><ol>\n";
    private static final String END_TAG = "</ol></div>\n";
    private static final String NOTATION_REGEX_LINEHEAD = "^[ \t]*#+ +[^#]";
    private static final String NOTATION_REGEX_LINETAIL = "";
    public static final String NOTATION_REGEX = "^[ \t]*#+ +[^#]..*";
    private boolean isBlockEnd_ = false;
    private String remain_;

    public WikiOrderedListBlockParser(WikiEngine wikiEngine) {
        this(wikiEngine, WikiBlockParser.Status.INIT);
    }

    public WikiOrderedListBlockParser(WikiEngine wikiEngine, WikiBlockParser.Status status) {
        super(wikiEngine);
        this.status_ = status;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        this.status_ = WikiBlockParser.Status.OPEN;
        buf.append(START_TAG);
        return line;
    }

    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        if (line.matches(NOTATION_REGEX)) {
            String token = line.substring(line.indexOf("#"));
            int countToken = this.countToken(token, '#');
            if (countToken > 1) {
                String daughterPart = token.substring(1);
                if (this.status_ == WikiBlockParser.Status.OPEN) {
                    this.startDaughterParse(new WikiBlockParserCreator.Creator(){

                        @Override
                        public WikiOrderedListBlockParser create(WikiEngine wikiEngine) {
                            return new WikiOrderedListBlockParser(wikiEngine, WikiBlockParser.Status.OPEN);
                        }
                    });
                    this.daughterParser_.startElementProcess(daughterPart, buf);
                }
                this.daughterParser_.parse(daughterPart, buf);
            } else {
                if (this.status_ == WikiBlockParser.Status.NESTING) {
                    this.daughterParser_.endElementProcess(line, buf);
                    this.daughterParser_ = null;
                    this.status_ = WikiBlockParser.Status.OPEN;
                }
                super.parse(line, buf);
                this.remain_ = NOTATION_REGEX_LINETAIL;
            }
        } else {
            this.isBlockEnd_ = true;
            this.remain_ = line;
        }
        return NOTATION_REGEX_LINETAIL;
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        if (this.status_ == WikiBlockParser.Status.NESTING) {
            this.daughterParser_.endElementProcess(line, buf);
        }
        buf.append("</ol></div>\n\n");
        return this.remain_;
    }

    @Override
    public boolean isBlockEnd() {
        return this.isBlockEnd_;
    }
}

