/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import java.util.ArrayList;
import java.util.ResourceBundle;

public class WikiTOCBuilder {
    private static final String MACRO_INSERTTOC = "{{#TOC}}";
    private ArrayList<HeadlineNode> headlineList_ = new ArrayList();

    public void add(String id, int level) {
        this.headlineList_.add(new HeadlineNode(id, level));
    }

    public String buildTOC(String line) {
        StringBuffer buf = new StringBuffer("");
        ResourceBundle bundle = ResourceBundle.getBundle("com.wiki.standalone.moxkiriya.resources.moxkiriya");
        if (line != null && line.startsWith(MACRO_INSERTTOC)) {
            buf.append("<div class=\"tocbox\">\n<div class=\"title\">" + bundle.getString("key.Contents") + "</div>\n");
            buf.append(this.buildTOCList());
            buf.append("</div>\n");
        }
        return buf.toString();
    }

    private String buildTOCList() {
        int depth = 0;
        StringBuffer buf = new StringBuffer("<ul>\n");
        for (HeadlineNode node : this.headlineList_) {
            if (node.headLineLevel_ - 2 < depth) {
                while (node.headLineLevel_ - 2 < depth) {
                    --depth;
                    buf.append("</ul>\n");
                }
            } else if (node.headLineLevel_ - 2 > depth) {
                while (node.headLineLevel_ - 2 > depth) {
                    ++depth;
                    buf.append("<ul>\n");
                }
            }
            buf.append("<li><a href=\"#" + node.id_ + "\")>" + node.id_ + "</a></li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }

    class HeadlineNode {
        String id_;
        int headLineLevel_;

        HeadlineNode(String id, int level) {
            this.id_ = id;
            this.headLineLevel_ = level;
        }
    }
}

