/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParser;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserBase;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiBlockParserCreator;
import com.wiki.standalone.moxkiriya.parser.blockparser.WikiTableRowBlockParser;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;

public class WikiTableBlockParser
extends WikiBlockParserBase {
    private static final String START_TAG = "<div><table";
    private static final String END_TAG = "</table></div>\n";
    private static final String NOTATION_REGEX_LINEHEAD = "^[ \t]*" + Pattern.quote("{|");
    private static final String NOTATION_REGEX_LINETAIL = "^[ \t]*" + Pattern.quote("|}");
    public static final String NOTATION_REGEX = String.valueOf(NOTATION_REGEX_LINEHEAD) + ".*";
    private static final LinkedHashMap<String, String> selectorMap_ = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("#", "id=");
            this.put(".", "class=");
        }
    };
    private StringBuffer rowBuf_;
    private final WikiBlockParserCreator creator_;

    public WikiTableBlockParser(WikiEngine wikiEngine) {
        super(wikiEngine);
        this.creator_ = new WikiBlockParserCreator(this.wikiEngine_){

            @Override
            public WikiBlockParser create(String line) {
                return new WikiTableRowBlockParser(WikiTableBlockParser.this.wikiEngine_);
            }
        };
        this.status_ = WikiBlockParser.Status.INIT;
    }

    @Override
    public String startElementProcess(String line, StringBuffer buf) {
        buf.append(START_TAG);
        String style = line.replaceFirst(NOTATION_REGEX_LINEHEAD, "").trim();
        String selector = "";
        if (!style.isEmpty()) {
            for (String key : selectorMap_.keySet()) {
                if (!style.startsWith(key)) continue;
                selector = selectorMap_.get(key);
                style = style.substring(style.indexOf(key) + key.length());
                break;
            }
            if (!selector.isEmpty()) {
                buf.append(" ");
                buf.append(selector);
                buf.append("\"" + style + "\"");
            }
        }
        buf.append(">\n");
        return "";
    }

    @Override
    public String parse(String line, StringBuffer buf) throws Exception {
        if (line.matches(String.valueOf(NOTATION_REGEX_LINETAIL) + ".*")) {
            this.isBlockEnd_ = true;
            this.remain_ = line.replaceFirst(NOTATION_REGEX_LINETAIL, "");
            line = "";
        } else {
            if (this.rowBuf_ == null) {
                this.rowBuf_ = new StringBuffer();
            }
            if (this.status_ == WikiBlockParser.Status.INIT) {
                this.status_ = WikiBlockParser.Status.OPEN;
            } else if (this.status_ == WikiBlockParser.Status.OPEN) {
                this.startDaughterParse(this.creator_, line);
                line = this.daughterParser_.startElementProcess(line, this.rowBuf_);
            } else if (this.status_ == WikiBlockParser.Status.NESTING) {
                line = this.daughterParser_.parse(line, this.rowBuf_);
                if (this.daughterParser_.isBlockEnd()) {
                    line = this.daughterParser_.endElementProcess(line, this.rowBuf_);
                    this.status_ = WikiBlockParser.Status.OPEN;
                }
            }
        }
        if (line.startsWith("|-")) {
            this.flushRowBuf(buf);
            line = "";
        }
        return line;
    }

    @Override
    public String endElementProcess(String line, StringBuffer buf) {
        if (this.status_ == WikiBlockParser.Status.NESTING) {
            this.daughterParser_.endElementProcess(line, this.rowBuf_);
            this.status_ = WikiBlockParser.Status.OPEN;
        }
        this.flushRowBuf(buf);
        buf.append("</table></div>\n\n");
        return this.remain_;
    }

    private void flushRowBuf(StringBuffer buf) {
        if (this.rowBuf_ != null && this.rowBuf_.length() > 0) {
            buf.append("<tr>\n");
            buf.append(this.rowBuf_);
            buf.append("</tr>\n");
            this.rowBuf_ = null;
        }
    }
}

